/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumberDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumberRequestDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumbersResponseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ActiveNumberApi {
    private static final Logger LOGGER = Logger.getLogger(ActiveNumberApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public ActiveNumberApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public ActiveNumberDto numberServiceGetActiveNumber(String projectId, String phoneNumber) throws ApiException {
        LOGGER.finest("[numberServiceGetActiveNumber] projectId: " + projectId + ", phoneNumber: " + phoneNumber);
        HttpRequest httpRequest = this.numberServiceGetActiveNumberRequestBuilder(projectId, phoneNumber);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceGetActiveNumberRequestBuilder(String projectId, String phoneNumber) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceGetActiveNumber");
        }
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling numberServiceGetActiveNumber");
        }
        String localVarPath = "/v1/projects/{projectId}/activeNumbers/{phoneNumber}".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString())).replaceAll("\\{phoneNumber\\}", URLParameterUtils.encodeParameterValue(phoneNumber.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ActiveNumbersResponseDto numberServiceListActiveNumbers(String projectId, String regionCode, String type, String numberPatternPattern, String numberPatternSearchPattern, List<String> capability, Integer pageSize, String pageToken, String orderBy) throws ApiException {
        LOGGER.finest("[numberServiceListActiveNumbers] projectId: " + projectId + ", regionCode: " + regionCode + ", type: " + type + ", numberPatternPattern: " + numberPatternPattern + ", numberPatternSearchPattern: " + numberPatternSearchPattern + ", capability: " + capability + ", pageSize: " + pageSize + ", pageToken: " + pageToken + ", orderBy: " + orderBy);
        HttpRequest httpRequest = this.numberServiceListActiveNumbersRequestBuilder(projectId, regionCode, type, numberPatternPattern, numberPatternSearchPattern, capability, pageSize, pageToken, orderBy);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ActiveNumbersResponseDto> localVarReturnType = new TypeReference<ActiveNumbersResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceListActiveNumbersRequestBuilder(String projectId, String regionCode, String type, String numberPatternPattern, String numberPatternSearchPattern, List<String> capability, Integer pageSize, String pageToken, String orderBy) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceListActiveNumbers");
        }
        if (regionCode == null) {
            throw new ApiException(400, "Missing the required parameter 'regionCode' when calling numberServiceListActiveNumbers");
        }
        if (type == null) {
            throw new ApiException(400, "Missing the required parameter 'type' when calling numberServiceListActiveNumbers");
        }
        String localVarPath = "/v1/projects/{projectId}/activeNumbers".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != regionCode) {
            localVarQueryParams.add(new URLParameter("regionCode", regionCode, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != numberPatternPattern) {
            localVarQueryParams.add(new URLParameter("numberPattern.pattern", numberPatternPattern, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != numberPatternSearchPattern) {
            localVarQueryParams.add(new URLParameter("numberPattern.searchPattern", numberPatternSearchPattern, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != type) {
            localVarQueryParams.add(new URLParameter("type", type, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != capability) {
            localVarQueryParams.add(new URLParameter("capability", capability, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != pageSize) {
            localVarQueryParams.add(new URLParameter("pageSize", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != pageToken) {
            localVarQueryParams.add(new URLParameter("pageToken", pageToken, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != orderBy) {
            localVarQueryParams.add(new URLParameter("orderBy", orderBy, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ActiveNumberDto numberServiceReleaseNumber(String projectId, String phoneNumber) throws ApiException {
        LOGGER.finest("[numberServiceReleaseNumber] projectId: " + projectId + ", phoneNumber: " + phoneNumber);
        HttpRequest httpRequest = this.numberServiceReleaseNumberRequestBuilder(projectId, phoneNumber);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceReleaseNumberRequestBuilder(String projectId, String phoneNumber) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceReleaseNumber");
        }
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling numberServiceReleaseNumber");
        }
        String localVarPath = "/v1/projects/{projectId}/activeNumbers/{phoneNumber}:release".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString())).replaceAll("\\{phoneNumber\\}", URLParameterUtils.encodeParameterValue(phoneNumber.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ActiveNumberDto numberServiceUpdateActiveNumber(String projectId, String phoneNumber, ActiveNumberRequestDto activeNumberRequestDto) throws ApiException {
        LOGGER.finest("[numberServiceUpdateActiveNumber] projectId: " + projectId + ", phoneNumber: " + phoneNumber + ", activeNumberRequestDto: " + activeNumberRequestDto);
        HttpRequest httpRequest = this.numberServiceUpdateActiveNumberRequestBuilder(projectId, phoneNumber, activeNumberRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceUpdateActiveNumberRequestBuilder(String projectId, String phoneNumber, ActiveNumberRequestDto activeNumberRequestDto) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceUpdateActiveNumber");
        }
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling numberServiceUpdateActiveNumber");
        }
        String localVarPath = "/v1/projects/{projectId}/activeNumbers/{phoneNumber}".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString())).replaceAll("\\{phoneNumber\\}", URLParameterUtils.encodeParameterValue(phoneNumber.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, activeNumberRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.PATCH, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

