/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumberDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.AvailableNumberDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.AvailableNumbersResponseDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.RentAnyNumberRequestDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.RentNumberRequestDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableNumberApi {
    private static final Logger LOGGER = Logger.getLogger(AvailableNumberApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public AvailableNumberApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public AvailableNumberDto numberServiceGetAvailableNumber(String projectId, String phoneNumber) throws ApiException {
        LOGGER.finest("[numberServiceGetAvailableNumber] projectId: " + projectId + ", phoneNumber: " + phoneNumber);
        HttpRequest httpRequest = this.numberServiceGetAvailableNumberRequestBuilder(projectId, phoneNumber);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<AvailableNumberDto> localVarReturnType = new TypeReference<AvailableNumberDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceGetAvailableNumberRequestBuilder(String projectId, String phoneNumber) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceGetAvailableNumber");
        }
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling numberServiceGetAvailableNumber");
        }
        String localVarPath = "/v1/projects/{projectId}/availableNumbers/{phoneNumber}".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString())).replaceAll("\\{phoneNumber\\}", URLParameterUtils.encodeParameterValue(phoneNumber.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public AvailableNumbersResponseDto numberServiceListAvailableNumbers(String projectId, String regionCode, String type, String numberPatternPattern, String numberPatternSearchPattern, List<String> capabilities, Integer size) throws ApiException {
        LOGGER.finest("[numberServiceListAvailableNumbers] projectId: " + projectId + ", regionCode: " + regionCode + ", type: " + type + ", numberPatternPattern: " + numberPatternPattern + ", numberPatternSearchPattern: " + numberPatternSearchPattern + ", capabilities: " + capabilities + ", size: " + size);
        HttpRequest httpRequest = this.numberServiceListAvailableNumbersRequestBuilder(projectId, regionCode, type, numberPatternPattern, numberPatternSearchPattern, capabilities, size);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<AvailableNumbersResponseDto> localVarReturnType = new TypeReference<AvailableNumbersResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceListAvailableNumbersRequestBuilder(String projectId, String regionCode, String type, String numberPatternPattern, String numberPatternSearchPattern, List<String> capabilities, Integer size) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceListAvailableNumbers");
        }
        if (regionCode == null) {
            throw new ApiException(400, "Missing the required parameter 'regionCode' when calling numberServiceListAvailableNumbers");
        }
        if (type == null) {
            throw new ApiException(400, "Missing the required parameter 'type' when calling numberServiceListAvailableNumbers");
        }
        String localVarPath = "/v1/projects/{projectId}/availableNumbers".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != numberPatternPattern) {
            localVarQueryParams.add(new URLParameter("numberPattern.pattern", numberPatternPattern, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != numberPatternSearchPattern) {
            localVarQueryParams.add(new URLParameter("numberPattern.searchPattern", numberPatternSearchPattern, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != regionCode) {
            localVarQueryParams.add(new URLParameter("regionCode", regionCode, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != type) {
            localVarQueryParams.add(new URLParameter("type", type, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != capabilities) {
            localVarQueryParams.add(new URLParameter("capabilities", capabilities, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != size) {
            localVarQueryParams.add(new URLParameter("size", size, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ActiveNumberDto numberServiceRentAnyNumber(String projectId, RentAnyNumberRequestDto rentAnyNumberRequestDto) throws ApiException {
        LOGGER.finest("[numberServiceRentAnyNumber] projectId: " + projectId + ", rentAnyNumberRequestDto: " + rentAnyNumberRequestDto);
        HttpRequest httpRequest = this.numberServiceRentAnyNumberRequestBuilder(projectId, rentAnyNumberRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceRentAnyNumberRequestBuilder(String projectId, RentAnyNumberRequestDto rentAnyNumberRequestDto) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceRentAnyNumber");
        }
        if (rentAnyNumberRequestDto == null) {
            throw new ApiException(400, "Missing the required parameter 'rentAnyNumberRequestDto' when calling numberServiceRentAnyNumber");
        }
        String localVarPath = "/v1/projects/{projectId}/availableNumbers:rentAny".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, rentAnyNumberRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ActiveNumberDto numberServiceRentNumber(String projectId, String phoneNumber, RentNumberRequestDto rentNumberRequestDto) throws ApiException {
        LOGGER.finest("[numberServiceRentNumber] projectId: " + projectId + ", phoneNumber: " + phoneNumber + ", rentNumberRequestDto: " + rentNumberRequestDto);
        HttpRequest httpRequest = this.numberServiceRentNumberRequestBuilder(projectId, phoneNumber, rentNumberRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceRentNumberRequestBuilder(String projectId, String phoneNumber, RentNumberRequestDto rentNumberRequestDto) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceRentNumber");
        }
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling numberServiceRentNumber");
        }
        if (rentNumberRequestDto == null) {
            throw new ApiException(400, "Missing the required parameter 'rentNumberRequestDto' when calling numberServiceRentNumber");
        }
        String localVarPath = "/v1/projects/{projectId}/availableNumbers/{phoneNumber}:rent".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString())).replaceAll("\\{phoneNumber\\}", URLParameterUtils.encodeParameterValue(phoneNumber.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, rentNumberRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

