/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.numbers.models.dto.v1.ListAvailableRegionsResponseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableRegionsApi {
    private static final Logger LOGGER = Logger.getLogger(AvailableRegionsApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public AvailableRegionsApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public ListAvailableRegionsResponseDto numberServiceListAvailableRegions(String projectId, List<String> types) throws ApiException {
        LOGGER.finest("[numberServiceListAvailableRegions] projectId: " + projectId + ", types: " + types);
        HttpRequest httpRequest = this.numberServiceListAvailableRegionsRequestBuilder(projectId, types);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ListAvailableRegionsResponseDto> localVarReturnType = new TypeReference<ListAvailableRegionsResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest numberServiceListAvailableRegionsRequestBuilder(String projectId, List<String> types) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling numberServiceListAvailableRegions");
        }
        String localVarPath = "/v1/projects/{projectId}/availableRegions".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != types) {
            localVarQueryParams.add(new URLParameter("types", types, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

