/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.numbers.models.dto.v1.CallbackConfigurationDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.CallbackConfigurationUpdateDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CallbackConfigurationApi {
    private static final Logger LOGGER = Logger.getLogger(CallbackConfigurationApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public CallbackConfigurationApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public CallbackConfigurationDto getCallbackConfiguration(String projectId) throws ApiException {
        LOGGER.finest("[getCallbackConfiguration] projectId: " + projectId);
        HttpRequest httpRequest = this.getCallbackConfigurationRequestBuilder(projectId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<CallbackConfigurationDto> localVarReturnType = new TypeReference<CallbackConfigurationDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest getCallbackConfigurationRequestBuilder(String projectId) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getCallbackConfiguration");
        }
        String localVarPath = "/v1/projects/{projectId}/callbackConfiguration".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public CallbackConfigurationDto updateCallbackConfiguration(String projectId, CallbackConfigurationUpdateDto callbackConfigurationUpdateDto) throws ApiException {
        LOGGER.finest("[updateCallbackConfiguration] projectId: " + projectId + ", callbackConfigurationUpdateDto: " + callbackConfigurationUpdateDto);
        HttpRequest httpRequest = this.updateCallbackConfigurationRequestBuilder(projectId, callbackConfigurationUpdateDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<CallbackConfigurationDto> localVarReturnType = new TypeReference<CallbackConfigurationDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest updateCallbackConfigurationRequestBuilder(String projectId, CallbackConfigurationUpdateDto callbackConfigurationUpdateDto) throws ApiException {
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling updateCallbackConfiguration");
        }
        String localVarPath = "/v1/projects/{projectId}/callbackConfiguration".replaceAll("\\{projectId\\}", URLParameterUtils.encodeParameterValue(projectId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BasicAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, callbackConfigurationUpdateDto);
        return new HttpRequest(localVarPath, HttpMethod.PATCH, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

