/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models;

import com.sinch.sdk.domains.numbers.models.Capability;
import com.sinch.sdk.domains.numbers.models.Money;
import com.sinch.sdk.domains.numbers.models.NumberType;
import com.sinch.sdk.domains.numbers.models.SMSConfiguration;
import com.sinch.sdk.domains.numbers.models.VoiceConfiguration;
import java.time.Instant;
import java.util.Collection;

public class ActiveNumber {
    private final String phoneNumber;
    private final String projectId;
    private final String displayName;
    private final String regionCode;
    private final NumberType type;
    private final Collection<Capability> capability;
    private final Money money;
    private final Integer paymentIntervalMonths;
    private final Instant nextChargeDate;
    private final Instant expireAt;
    private final SMSConfiguration smsConfiguration;
    private final VoiceConfiguration voiceConfiguration;
    private final String callbackUrl;

    public ActiveNumber(String phoneNumber, String projectId, String displayName, String regionCode, NumberType type, Collection<Capability> capability, Money money, Integer paymentIntervalMonths, Instant nextChargeDate, Instant expireAt, SMSConfiguration smsConfiguration, VoiceConfiguration voiceConfiguration, String callbackUrl) {
        this.phoneNumber = phoneNumber;
        this.projectId = projectId;
        this.displayName = displayName;
        this.regionCode = regionCode;
        this.type = type;
        this.capability = capability;
        this.money = money;
        this.paymentIntervalMonths = paymentIntervalMonths;
        this.nextChargeDate = nextChargeDate;
        this.expireAt = expireAt;
        this.smsConfiguration = smsConfiguration;
        this.voiceConfiguration = voiceConfiguration;
        this.callbackUrl = callbackUrl;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public NumberType getType() {
        return this.type;
    }

    public Collection<Capability> getCapability() {
        return this.capability;
    }

    public Money getMoney() {
        return this.money;
    }

    public Integer getPaymentIntervalMonths() {
        return this.paymentIntervalMonths;
    }

    public Instant getNextChargeDate() {
        return this.nextChargeDate;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    public SMSConfiguration getSmsConfiguration() {
        return this.smsConfiguration;
    }

    public VoiceConfiguration getVoiceConfiguration() {
        return this.voiceConfiguration;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ActiveNumber{phoneNumber='" + this.phoneNumber + '\'' + ", projectId='" + this.projectId + '\'' + ", displayName='" + this.displayName + '\'' + ", regionCode='" + this.regionCode + '\'' + ", type=" + this.type + ", capability=" + this.capability + ", money=" + this.money + ", paymentIntervalMonths=" + this.paymentIntervalMonths + ", nextChargeDate=" + this.nextChargeDate + ", expireAt=" + this.expireAt + ", smsConfiguration=" + this.smsConfiguration + ", voiceConfiguration=" + this.voiceConfiguration + ", callbackUrl='" + this.callbackUrl + '\'' + '}';
    }

    public static class Builder {
        private String phoneNumber;
        private String projectId;
        private String displayName;
        private String regionCode;
        private NumberType type;
        private Collection<Capability> capability;
        private Money money;
        private Integer paymentIntervalMonths;
        private Instant nextChargeDate;
        private Instant expireAt;
        private SMSConfiguration smsConfiguration;
        private VoiceConfiguration voiceConfiguration;
        private String callbackUrl;

        private Builder() {
        }

        public ActiveNumber build() {
            return new ActiveNumber(this.phoneNumber, this.projectId, this.displayName, this.regionCode, this.type, this.capability, this.money, this.paymentIntervalMonths, this.nextChargeDate, this.expireAt, this.smsConfiguration, this.voiceConfiguration, this.callbackUrl);
        }

        public Builder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setRegionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public Builder setType(NumberType type) {
            this.type = type;
            return this;
        }

        public Builder setCapability(Collection<Capability> capability) {
            this.capability = capability;
            return this;
        }

        public Builder setMoney(Money money) {
            this.money = money;
            return this;
        }

        public Builder setPaymentIntervalMonths(Integer paymentIntervalMonths) {
            this.paymentIntervalMonths = paymentIntervalMonths;
            return this;
        }

        public Builder setNextChargeDate(Instant nextChargeDate) {
            this.nextChargeDate = nextChargeDate;
            return this;
        }

        public Builder setExpireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public Builder setSmsConfiguration(SMSConfiguration smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public Builder setVoiceConfiguration(VoiceConfiguration voiceConfiguration) {
            this.voiceConfiguration = voiceConfiguration;
            return this;
        }

        public Builder setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }
    }
}

