/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models;

public class Money {
    private final String currencyCode;
    private final Double amount;

    public Money(String currencyCode, Double amount) {
        this.currencyCode = currencyCode;
        this.amount = amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Double getAmount() {
        return this.amount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Money{currencyCode='" + this.currencyCode + '\'' + ", amount='" + this.amount + '\'' + '}';
    }

    public static class Builder {
        private String currencyCode;
        private Double amount;

        private Builder() {
        }

        Builder setCurrencyCode(String value) {
            this.currencyCode = value;
            return this;
        }

        Builder setAmount(Double value) {
            this.amount = value;
            return this;
        }

        Money build() {
            return new Money(this.currencyCode, this.amount);
        }
    }
}

