/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models;

import com.sinch.sdk.domains.numbers.models.SearchPattern;

public class NumberPattern {
    private final String pattern;
    private final SearchPattern searchPattern;

    public NumberPattern(String pattern, SearchPattern searchPattern) {
        this.pattern = pattern;
        this.searchPattern = searchPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public SearchPattern getSearchPattern() {
        return this.searchPattern;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "NumberPattern{pattern='" + this.pattern + '\'' + ", searchPattern='" + this.searchPattern + '\'' + '}';
    }

    public static class Builder {
        private String pattern;
        private SearchPattern searchPattern;

        private Builder() {
        }

        public Builder setPattern(String value) {
            this.pattern = value;
            return this;
        }

        public Builder setSearchPattern(SearchPattern value) {
            this.searchPattern = value;
            return this;
        }

        public NumberPattern build() {
            return new NumberPattern(this.pattern, this.searchPattern);
        }
    }
}

