/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models.requests;

import com.sinch.sdk.domains.numbers.models.Capability;
import com.sinch.sdk.domains.numbers.models.NumberPattern;
import com.sinch.sdk.domains.numbers.models.NumberType;
import com.sinch.sdk.domains.numbers.models.OrderBy;
import java.util.Collection;
import java.util.Optional;

public class ActiveNumberListRequestParameters {
    private final String regionCode;
    private final NumberType type;
    private final NumberPattern numberPattern;
    private final Collection<Capability> capabilities;
    private final Integer pageSize;
    private final String pageToken;
    private final OrderBy orderBy;

    public ActiveNumberListRequestParameters(String regionCode, NumberType type, NumberPattern numberPattern, Collection<Capability> capabilities, Integer pageSize, String pageToken, OrderBy orderBy) {
        this.regionCode = regionCode;
        this.type = type;
        this.numberPattern = numberPattern;
        this.capabilities = capabilities;
        this.pageSize = pageSize;
        this.pageToken = pageToken;
        this.orderBy = orderBy;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public NumberType getType() {
        return this.type;
    }

    public Optional<NumberPattern> getNumberPattern() {
        return Optional.ofNullable(this.numberPattern);
    }

    public Optional<Collection<Capability>> getCapabilities() {
        return Optional.ofNullable(this.capabilities);
    }

    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(this.pageSize);
    }

    public Optional<String> getPageToken() {
        return Optional.ofNullable(this.pageToken);
    }

    public Optional<OrderBy> getOrderBy() {
        return Optional.ofNullable(this.orderBy);
    }

    public String toString() {
        return "ActiveNumberListRequestParameters{regionCode='" + this.regionCode + '\'' + ", type=" + this.type + ", numberPattern=" + this.numberPattern + ", capabilities=" + this.capabilities + ", pageSize=" + this.pageSize + ", pageToken=" + this.pageToken + ", orderBy=" + this.orderBy + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String regionCode;
        NumberType type;
        NumberPattern numberPattern;
        Collection<Capability> capabilities;
        Integer pageSize;
        String pageToken;
        OrderBy orderBy;

        private Builder() {
        }

        public Builder(ActiveNumberListRequestParameters parameters) {
            this.setRegionCode(parameters.regionCode).setType(parameters.type).setNumberPattern(parameters.numberPattern).setCapabilities(parameters.capabilities).setPageSize(parameters.pageSize).setPageToken(parameters.pageToken).setOrderBy(parameters.orderBy);
        }

        public Builder setRegionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public Builder setType(NumberType type) {
            this.type = type;
            return this;
        }

        public Builder setNumberPattern(NumberPattern numberPattern) {
            this.numberPattern = numberPattern;
            return this;
        }

        public Builder setCapabilities(Collection<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setPageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder setOrderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public ActiveNumberListRequestParameters build() {
            return new ActiveNumberListRequestParameters(this.regionCode, this.type, this.numberPattern, this.capabilities, this.pageSize, this.pageToken, this.orderBy);
        }
    }
}

