/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models.requests;

import com.sinch.sdk.domains.numbers.models.Capability;
import com.sinch.sdk.domains.numbers.models.NumberPattern;
import com.sinch.sdk.domains.numbers.models.NumberType;
import java.util.Collection;
import java.util.Optional;

public class AvailableNumberListAllRequestParameters {
    private final String regionCode;
    private final NumberType type;
    private final NumberPattern numberPattern;
    private final Collection<Capability> capabilities;
    private final Integer size;

    public AvailableNumberListAllRequestParameters(String regionCode, NumberType type, NumberPattern numberPattern, Collection<Capability> capabilities, Integer size) {
        this.regionCode = regionCode;
        this.type = type;
        this.numberPattern = numberPattern;
        this.capabilities = capabilities;
        this.size = size;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public NumberType getType() {
        return this.type;
    }

    public Optional<NumberPattern> getNumberPattern() {
        return Optional.ofNullable(this.numberPattern);
    }

    public Optional<Collection<Capability>> getCapabilities() {
        return Optional.ofNullable(this.capabilities);
    }

    public Optional<Integer> getSize() {
        return Optional.ofNullable(this.size);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String regionCode;
        NumberType type;
        NumberPattern numberPattern;
        Collection<Capability> capabilities;
        Integer size;

        private Builder() {
        }

        public Builder setRegionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public Builder setType(NumberType type) {
            this.type = type;
            return this;
        }

        public Builder setNumberPattern(NumberPattern numberPattern) {
            this.numberPattern = numberPattern;
            return this;
        }

        public Builder setCapabilities(Collection<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder setSize(Integer size) {
            this.size = size;
            return this;
        }

        public AvailableNumberListAllRequestParameters build() {
            return new AvailableNumberListAllRequestParameters(this.regionCode, this.type, this.numberPattern, this.capabilities, this.size);
        }
    }
}

