/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models.requests;

import com.sinch.sdk.domains.numbers.models.Capability;
import com.sinch.sdk.domains.numbers.models.NumberPattern;
import com.sinch.sdk.domains.numbers.models.NumberType;
import com.sinch.sdk.domains.numbers.models.requests.RentSMSConfigurationRequestParameters;
import com.sinch.sdk.domains.numbers.models.requests.RentVoiceConfigurationRequestParameters;
import java.util.Collection;
import java.util.Optional;

public class AvailableNumberRentAnyRequestParameters {
    private final String regionCode;
    private final NumberType type;
    private final NumberPattern numberPattern;
    private final Collection<Capability> capabilities;
    private final RentSMSConfigurationRequestParameters smsConfiguration;
    private final RentVoiceConfigurationRequestParameters voiceConfiguration;
    private final String callbackUrl;

    public AvailableNumberRentAnyRequestParameters(String regionCode, NumberType type, NumberPattern numberPattern, Collection<Capability> capabilities, RentSMSConfigurationRequestParameters smsConfiguration, RentVoiceConfigurationRequestParameters voiceConfiguration, String callbackUrl) {
        this.regionCode = regionCode;
        this.type = type;
        this.numberPattern = numberPattern;
        this.capabilities = capabilities;
        this.smsConfiguration = smsConfiguration;
        this.voiceConfiguration = voiceConfiguration;
        this.callbackUrl = callbackUrl;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public NumberType getType() {
        return this.type;
    }

    public Optional<NumberPattern> getNumberPattern() {
        return Optional.ofNullable(this.numberPattern);
    }

    public Optional<Collection<Capability>> getCapabilities() {
        return Optional.ofNullable(this.capabilities);
    }

    public Optional<RentSMSConfigurationRequestParameters> getSmsConfiguration() {
        return Optional.ofNullable(this.smsConfiguration);
    }

    public Optional<RentVoiceConfigurationRequestParameters> getVoiceConfiguration() {
        return Optional.ofNullable(this.voiceConfiguration);
    }

    public Optional<String> getCallBackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String regionCode;
        NumberType type;
        NumberPattern numberPattern;
        Collection<Capability> capabilities;
        RentSMSConfigurationRequestParameters smsConfiguration;
        RentVoiceConfigurationRequestParameters voiceConfiguration;
        String callbackUrl;

        private Builder() {
        }

        public Builder setRegionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public Builder setType(NumberType type) {
            this.type = type;
            return this;
        }

        public Builder setNumberPattern(NumberPattern numberPattern) {
            this.numberPattern = numberPattern;
            return this;
        }

        public Builder setCapabilities(Collection<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder setSmsConfiguration(RentSMSConfigurationRequestParameters smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public Builder setVoiceConfiguration(RentVoiceConfigurationRequestParameters voiceConfiguration) {
            this.voiceConfiguration = voiceConfiguration;
            return this;
        }

        public Builder setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public AvailableNumberRentAnyRequestParameters build() {
            return new AvailableNumberRentAnyRequestParameters(this.regionCode, this.type, this.numberPattern, this.capabilities, this.smsConfiguration, this.voiceConfiguration, this.callbackUrl);
        }
    }
}

