/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models.requests;

import com.sinch.sdk.domains.numbers.models.requests.RentSMSConfigurationRequestParameters;
import com.sinch.sdk.domains.numbers.models.requests.RentVoiceConfigurationRequestParameters;
import java.util.Optional;

public class AvailableNumberRentRequestParameters {
    private final RentSMSConfigurationRequestParameters smsConfiguration;
    private final RentVoiceConfigurationRequestParameters voiceConfiguration;
    private final String callbackUrl;

    public AvailableNumberRentRequestParameters(RentSMSConfigurationRequestParameters smsConfiguration, RentVoiceConfigurationRequestParameters voiceConfiguration, String callbackUrl) {
        this.smsConfiguration = smsConfiguration;
        this.voiceConfiguration = voiceConfiguration;
        this.callbackUrl = callbackUrl;
    }

    public Optional<RentSMSConfigurationRequestParameters> getSmsConfiguration() {
        return Optional.ofNullable(this.smsConfiguration);
    }

    public Optional<RentVoiceConfigurationRequestParameters> getVoiceConfiguration() {
        return Optional.ofNullable(this.voiceConfiguration);
    }

    public Optional<String> getCallBackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        RentSMSConfigurationRequestParameters smsConfiguration;
        RentVoiceConfigurationRequestParameters voiceConfiguration;
        String callbackUrl;

        private Builder() {
        }

        public Builder setSmsConfiguration(RentSMSConfigurationRequestParameters smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public Builder setVoiceConfiguration(RentVoiceConfigurationRequestParameters voiceConfiguration) {
            this.voiceConfiguration = voiceConfiguration;
            return this;
        }

        public Builder setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public AvailableNumberRentRequestParameters build() {
            return new AvailableNumberRentRequestParameters(this.smsConfiguration, this.voiceConfiguration, this.callbackUrl);
        }
    }
}

