/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.numbers.models.responses;

import com.sinch.sdk.core.models.pagination.ListResponse;
import com.sinch.sdk.core.models.pagination.Page;
import com.sinch.sdk.core.utils.StringUtil;
import com.sinch.sdk.domains.numbers.ActiveNumberService;
import com.sinch.sdk.domains.numbers.models.ActiveNumber;
import com.sinch.sdk.domains.numbers.models.requests.ActiveNumberListRequestParameters;
import java.util.Collection;
import java.util.NoSuchElementException;

public class ActiveNumberListResponse
extends ListResponse<ActiveNumber> {
    private final Page<ActiveNumberListRequestParameters, ActiveNumber, String> page;
    private final ActiveNumberService service;

    public ActiveNumberListResponse(ActiveNumberService service, Page<ActiveNumberListRequestParameters, ActiveNumber, String> page) {
        this.service = service;
        this.page = page;
    }

    @Override
    public boolean hasNextPage() {
        return null != this.page.getNextPageToken() && !StringUtil.isEmpty(this.page.getNextPageToken());
    }

    public ActiveNumberListResponse nextPage() {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Reached the last page of the API response");
        }
        ActiveNumberListRequestParameters.Builder newParameters = new ActiveNumberListRequestParameters.Builder(this.page.getParameters());
        newParameters.setPageToken(this.page.getNextPageToken());
        return this.service.list(newParameters.build());
    }

    @Override
    public Collection<ActiveNumber> getContent() {
        return this.page.getEntities();
    }

    public String toString() {
        return "ActiveNumberListResponse{page=" + this.page + '}';
    }
}

