/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.adapters;

import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.models.pagination.Page;
import com.sinch.sdk.domains.sms.adapters.api.v1.GroupsApi;
import com.sinch.sdk.domains.sms.adapters.converters.GroupsDtoConverter;
import com.sinch.sdk.domains.sms.models.Group;
import com.sinch.sdk.domains.sms.models.SMSCursorPageNavigator;
import com.sinch.sdk.domains.sms.models.dto.v1.ApiGroupListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.CreateGroupResponseDto;
import com.sinch.sdk.domains.sms.models.requests.GroupCreateRequestParameters;
import com.sinch.sdk.domains.sms.models.requests.GroupReplaceRequestParameters;
import com.sinch.sdk.domains.sms.models.requests.GroupUpdateRequestParameters;
import com.sinch.sdk.domains.sms.models.requests.GroupsListRequestParameters;
import com.sinch.sdk.domains.sms.models.responses.GroupsListResponse;
import com.sinch.sdk.models.Configuration;
import java.util.Collection;

public class GroupsService
implements com.sinch.sdk.domains.sms.GroupsService {
    private Configuration configuration;
    private GroupsApi api;

    public GroupsService() {
    }

    private GroupsApi getApi() {
        return this.api;
    }

    public GroupsService(Configuration configuration, HttpClient httpClient) {
        this.configuration = configuration;
        this.api = new GroupsApi(httpClient, configuration.getSmsServer(), new HttpMapper());
    }

    @Override
    public Group get(String groupId) throws ApiException {
        CreateGroupResponseDto response = this.getApi().retrieveGroup(this.configuration.getProjectId(), groupId);
        return GroupsDtoConverter.convert(response);
    }

    @Override
    public Group create() throws ApiException {
        return this.create(null);
    }

    @Override
    public Group create(GroupCreateRequestParameters parameters) throws ApiException {
        GroupCreateRequestParameters guardParameters = null != parameters ? parameters : GroupCreateRequestParameters.builder().build();
        CreateGroupResponseDto response = this.getApi().createGroup(this.configuration.getProjectId(), GroupsDtoConverter.convert(guardParameters));
        return GroupsDtoConverter.convert(response);
    }

    @Override
    public GroupsListResponse list() throws ApiException {
        return this.list(null);
    }

    @Override
    public GroupsListResponse list(GroupsListRequestParameters parameters) throws ApiException {
        GroupsListRequestParameters guardParameters = null != parameters ? parameters : GroupsListRequestParameters.builder().build();
        ApiGroupListDto response = this.getApi().listGroups(this.configuration.getProjectId(), guardParameters.getPage().orElse(null), guardParameters.getPageSize().orElse(null));
        Collection<Group> content = GroupsDtoConverter.convert(response);
        SMSCursorPageNavigator navigator = new SMSCursorPageNavigator(response.getPage(), response.getPageSize());
        return new GroupsListResponse(this, new Page<GroupsListRequestParameters, Group, Integer>(guardParameters, content, navigator));
    }

    @Override
    public Group replace(String groupId, GroupReplaceRequestParameters parameters) throws ApiException {
        GroupReplaceRequestParameters guardParameters = null != parameters ? parameters : GroupReplaceRequestParameters.builder().build();
        CreateGroupResponseDto response = this.getApi().replaceGroup(this.configuration.getProjectId(), groupId, GroupsDtoConverter.convert(guardParameters));
        return GroupsDtoConverter.convert(response);
    }

    @Override
    public Group update(String groupId, GroupUpdateRequestParameters parameters) throws ApiException {
        GroupUpdateRequestParameters guardParameters = null != parameters ? parameters : GroupUpdateRequestParameters.builder().build();
        CreateGroupResponseDto response = this.getApi().updateGroup(this.configuration.getProjectId(), groupId, GroupsDtoConverter.convert(guardParameters));
        return GroupsDtoConverter.convert(response);
    }

    @Override
    public void delete(String groupId) throws ApiException {
        this.getApi().deleteGroup(this.configuration.getProjectId(), groupId);
    }

    @Override
    public Collection<String> listMembers(String groupId) throws ApiException {
        return this.getApi().getMembers(this.configuration.getProjectId(), groupId);
    }
}

