/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.sms.models.dto.v1.ApiBatchListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.ApiDeliveryFeedbackDto;
import com.sinch.sdk.domains.sms.models.dto.v1.DryRun200ResponseDto;
import com.sinch.sdk.domains.sms.models.dto.v1.SendSMS201ResponseDto;
import com.sinch.sdk.domains.sms.models.dto.v1.SendSMSRequestDto;
import com.sinch.sdk.domains.sms.models.dto.v1.UpdateBatchMessageRequestDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BatchesApi {
    private static final Logger LOGGER = Logger.getLogger(BatchesApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public BatchesApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public SendSMS201ResponseDto cancelBatchMessage(String servicePlanId, String batchId) throws ApiException {
        LOGGER.finest("[cancelBatchMessage] servicePlanId: " + servicePlanId + ", batchId: " + batchId);
        HttpRequest httpRequest = this.cancelBatchMessageRequestBuilder(servicePlanId, batchId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<SendSMS201ResponseDto> localVarReturnType = new TypeReference<SendSMS201ResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest cancelBatchMessageRequestBuilder(String servicePlanId, String batchId) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling cancelBatchMessage");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling cancelBatchMessage");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.DELETE, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public void deliveryFeedback(String servicePlanId, String batchId, ApiDeliveryFeedbackDto apiDeliveryFeedbackDto) throws ApiException {
        LOGGER.finest("[deliveryFeedback] servicePlanId: " + servicePlanId + ", batchId: " + batchId + ", apiDeliveryFeedbackDto: " + apiDeliveryFeedbackDto);
        HttpRequest httpRequest = this.deliveryFeedbackRequestBuilder(servicePlanId, batchId, apiDeliveryFeedbackDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            return;
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest deliveryFeedbackRequestBuilder(String servicePlanId, String batchId, ApiDeliveryFeedbackDto apiDeliveryFeedbackDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling deliveryFeedback");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling deliveryFeedback");
        }
        if (apiDeliveryFeedbackDto == null) {
            throw new ApiException(400, "Missing the required parameter 'apiDeliveryFeedbackDto' when calling deliveryFeedback");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}/delivery_feedback".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList(new String[0]);
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, apiDeliveryFeedbackDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public DryRun200ResponseDto dryRun(String servicePlanId, Boolean perRecipient, Integer numberOfRecipients, SendSMSRequestDto sendSMSRequestDto) throws ApiException {
        LOGGER.finest("[dryRun] servicePlanId: " + servicePlanId + ", perRecipient: " + perRecipient + ", numberOfRecipients: " + numberOfRecipients + ", sendSMSRequestDto: " + sendSMSRequestDto);
        HttpRequest httpRequest = this.dryRunRequestBuilder(servicePlanId, perRecipient, numberOfRecipients, sendSMSRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<DryRun200ResponseDto> localVarReturnType = new TypeReference<DryRun200ResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest dryRunRequestBuilder(String servicePlanId, Boolean perRecipient, Integer numberOfRecipients, SendSMSRequestDto sendSMSRequestDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling dryRun");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/dry_run".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != perRecipient) {
            localVarQueryParams.add(new URLParameter("per_recipient", perRecipient, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != numberOfRecipients) {
            localVarQueryParams.add(new URLParameter("number_of_recipients", numberOfRecipients, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, sendSMSRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public SendSMS201ResponseDto getBatchMessage(String servicePlanId, String batchId) throws ApiException {
        LOGGER.finest("[getBatchMessage] servicePlanId: " + servicePlanId + ", batchId: " + batchId);
        HttpRequest httpRequest = this.getBatchMessageRequestBuilder(servicePlanId, batchId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<SendSMS201ResponseDto> localVarReturnType = new TypeReference<SendSMS201ResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest getBatchMessageRequestBuilder(String servicePlanId, String batchId) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling getBatchMessage");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling getBatchMessage");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ApiBatchListDto listBatches(String servicePlanId, Integer page, Integer pageSize, String from, String startDate, String endDate, String clientReference) throws ApiException {
        LOGGER.finest("[listBatches] servicePlanId: " + servicePlanId + ", page: " + page + ", pageSize: " + pageSize + ", from: " + from + ", startDate: " + startDate + ", endDate: " + endDate + ", clientReference: " + clientReference);
        HttpRequest httpRequest = this.listBatchesRequestBuilder(servicePlanId, page, pageSize, from, startDate, endDate, clientReference);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ApiBatchListDto> localVarReturnType = new TypeReference<ApiBatchListDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest listBatchesRequestBuilder(String servicePlanId, Integer page, Integer pageSize, String from, String startDate, String endDate, String clientReference) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling listBatches");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != page) {
            localVarQueryParams.add(new URLParameter("page", page, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != pageSize) {
            localVarQueryParams.add(new URLParameter("page_size", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != from) {
            localVarQueryParams.add(new URLParameter("from", from, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != startDate) {
            localVarQueryParams.add(new URLParameter("start_date", startDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != endDate) {
            localVarQueryParams.add(new URLParameter("end_date", endDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != clientReference) {
            localVarQueryParams.add(new URLParameter("client_reference", clientReference, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public SendSMS201ResponseDto replaceBatch(String servicePlanId, String batchId, SendSMSRequestDto sendSMSRequestDto) throws ApiException {
        LOGGER.finest("[replaceBatch] servicePlanId: " + servicePlanId + ", batchId: " + batchId + ", sendSMSRequestDto: " + sendSMSRequestDto);
        HttpRequest httpRequest = this.replaceBatchRequestBuilder(servicePlanId, batchId, sendSMSRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<SendSMS201ResponseDto> localVarReturnType = new TypeReference<SendSMS201ResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest replaceBatchRequestBuilder(String servicePlanId, String batchId, SendSMSRequestDto sendSMSRequestDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling replaceBatch");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling replaceBatch");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, sendSMSRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.PUT, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public SendSMS201ResponseDto sendSMS(String servicePlanId, SendSMSRequestDto sendSMSRequestDto) throws ApiException {
        LOGGER.finest("[sendSMS] servicePlanId: " + servicePlanId + ", sendSMSRequestDto: " + sendSMSRequestDto);
        HttpRequest httpRequest = this.sendSMSRequestBuilder(servicePlanId, sendSMSRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<SendSMS201ResponseDto> localVarReturnType = new TypeReference<SendSMS201ResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest sendSMSRequestBuilder(String servicePlanId, SendSMSRequestDto sendSMSRequestDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling sendSMS");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, sendSMSRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public SendSMS201ResponseDto updateBatchMessage(String servicePlanId, String batchId, UpdateBatchMessageRequestDto updateBatchMessageRequestDto) throws ApiException {
        LOGGER.finest("[updateBatchMessage] servicePlanId: " + servicePlanId + ", batchId: " + batchId + ", updateBatchMessageRequestDto: " + updateBatchMessageRequestDto);
        HttpRequest httpRequest = this.updateBatchMessageRequestBuilder(servicePlanId, batchId, updateBatchMessageRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<SendSMS201ResponseDto> localVarReturnType = new TypeReference<SendSMS201ResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest updateBatchMessageRequestBuilder(String servicePlanId, String batchId, UpdateBatchMessageRequestDto updateBatchMessageRequestDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling updateBatchMessage");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling updateBatchMessage");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, updateBatchMessageRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

