/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.sms.models.dto.v1.DeliveryReportDto;
import com.sinch.sdk.domains.sms.models.dto.v1.DeliveryReportListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.RecipientDeliveryReportDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DeliveryReportsApi {
    private static final Logger LOGGER = Logger.getLogger(DeliveryReportsApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public DeliveryReportsApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public DeliveryReportDto getDeliveryReportByBatchId(String servicePlanId, String batchId, String type, String status, String code) throws ApiException {
        LOGGER.finest("[getDeliveryReportByBatchId] servicePlanId: " + servicePlanId + ", batchId: " + batchId + ", type: " + type + ", status: " + status + ", code: " + code);
        HttpRequest httpRequest = this.getDeliveryReportByBatchIdRequestBuilder(servicePlanId, batchId, type, status, code);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<DeliveryReportDto> localVarReturnType = new TypeReference<DeliveryReportDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest getDeliveryReportByBatchIdRequestBuilder(String servicePlanId, String batchId, String type, String status, String code) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling getDeliveryReportByBatchId");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling getDeliveryReportByBatchId");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}/delivery_report".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != type) {
            localVarQueryParams.add(new URLParameter("type", type, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != status) {
            localVarQueryParams.add(new URLParameter("status", status, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != code) {
            localVarQueryParams.add(new URLParameter("code", code, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public RecipientDeliveryReportDto getDeliveryReportByPhoneNumber(String servicePlanId, String batchId, String recipientMsisdn) throws ApiException {
        LOGGER.finest("[getDeliveryReportByPhoneNumber] servicePlanId: " + servicePlanId + ", batchId: " + batchId + ", recipientMsisdn: " + recipientMsisdn);
        HttpRequest httpRequest = this.getDeliveryReportByPhoneNumberRequestBuilder(servicePlanId, batchId, recipientMsisdn);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<RecipientDeliveryReportDto> localVarReturnType = new TypeReference<RecipientDeliveryReportDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest getDeliveryReportByPhoneNumberRequestBuilder(String servicePlanId, String batchId, String recipientMsisdn) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling getDeliveryReportByPhoneNumber");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling getDeliveryReportByPhoneNumber");
        }
        if (recipientMsisdn == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientMsisdn' when calling getDeliveryReportByPhoneNumber");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/batches/{batch_id}/delivery_report/{recipient_msisdn}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{batch_id\\}", URLParameterUtils.encodeParameterValue(batchId.toString())).replaceAll("\\{recipient_msisdn\\}", URLParameterUtils.encodeParameterValue(recipientMsisdn.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public DeliveryReportListDto getDeliveryReports(String servicePlanId, Integer page, Integer pageSize, String startDate, String endDate, String status, String code, String clientReference) throws ApiException {
        LOGGER.finest("[getDeliveryReports] servicePlanId: " + servicePlanId + ", page: " + page + ", pageSize: " + pageSize + ", startDate: " + startDate + ", endDate: " + endDate + ", status: " + status + ", code: " + code + ", clientReference: " + clientReference);
        HttpRequest httpRequest = this.getDeliveryReportsRequestBuilder(servicePlanId, page, pageSize, startDate, endDate, status, code, clientReference);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<DeliveryReportListDto> localVarReturnType = new TypeReference<DeliveryReportListDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest getDeliveryReportsRequestBuilder(String servicePlanId, Integer page, Integer pageSize, String startDate, String endDate, String status, String code, String clientReference) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling getDeliveryReports");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/delivery_reports".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != page) {
            localVarQueryParams.add(new URLParameter("page", page, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != pageSize) {
            localVarQueryParams.add(new URLParameter("page_size", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != startDate) {
            localVarQueryParams.add(new URLParameter("start_date", startDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != endDate) {
            localVarQueryParams.add(new URLParameter("end_date", endDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != status) {
            localVarQueryParams.add(new URLParameter("status", status, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != code) {
            localVarQueryParams.add(new URLParameter("code", code, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != clientReference) {
            localVarQueryParams.add(new URLParameter("client_reference", clientReference, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

