/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.sms.models.dto.v1.ApiGroupListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.CreateGroupResponseDto;
import com.sinch.sdk.domains.sms.models.dto.v1.GroupObjectDto;
import com.sinch.sdk.domains.sms.models.dto.v1.ReplaceGroupRequestDto;
import com.sinch.sdk.domains.sms.models.dto.v1.UpdateGroupRequestDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class GroupsApi {
    private static final Logger LOGGER = Logger.getLogger(GroupsApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public GroupsApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public CreateGroupResponseDto createGroup(String servicePlanId, GroupObjectDto groupObjectDto) throws ApiException {
        LOGGER.finest("[createGroup] servicePlanId: " + servicePlanId + ", groupObjectDto: " + groupObjectDto);
        HttpRequest httpRequest = this.createGroupRequestBuilder(servicePlanId, groupObjectDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<CreateGroupResponseDto> localVarReturnType = new TypeReference<CreateGroupResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest createGroupRequestBuilder(String servicePlanId, GroupObjectDto groupObjectDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling createGroup");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, groupObjectDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public void deleteGroup(String servicePlanId, String groupId) throws ApiException {
        LOGGER.finest("[deleteGroup] servicePlanId: " + servicePlanId + ", groupId: " + groupId);
        HttpRequest httpRequest = this.deleteGroupRequestBuilder(servicePlanId, groupId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            return;
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest deleteGroupRequestBuilder(String servicePlanId, String groupId) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling deleteGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroup");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups/{group_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{group_id\\}", URLParameterUtils.encodeParameterValue(groupId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList(new String[0]);
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.DELETE, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public List<String> getMembers(String servicePlanId, String groupId) throws ApiException {
        LOGGER.finest("[getMembers] servicePlanId: " + servicePlanId + ", groupId: " + groupId);
        HttpRequest httpRequest = this.getMembersRequestBuilder(servicePlanId, groupId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<List<String>> localVarReturnType = new TypeReference<List<String>>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest getMembersRequestBuilder(String servicePlanId, String groupId) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling getMembers");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getMembers");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups/{group_id}/members".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{group_id\\}", URLParameterUtils.encodeParameterValue(groupId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public ApiGroupListDto listGroups(String servicePlanId, Integer page, Integer pageSize) throws ApiException {
        LOGGER.finest("[listGroups] servicePlanId: " + servicePlanId + ", page: " + page + ", pageSize: " + pageSize);
        HttpRequest httpRequest = this.listGroupsRequestBuilder(servicePlanId, page, pageSize);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ApiGroupListDto> localVarReturnType = new TypeReference<ApiGroupListDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest listGroupsRequestBuilder(String servicePlanId, Integer page, Integer pageSize) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling listGroups");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != page) {
            localVarQueryParams.add(new URLParameter("page", page, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != pageSize) {
            localVarQueryParams.add(new URLParameter("page_size", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public CreateGroupResponseDto replaceGroup(String servicePlanId, String groupId, ReplaceGroupRequestDto replaceGroupRequestDto) throws ApiException {
        LOGGER.finest("[replaceGroup] servicePlanId: " + servicePlanId + ", groupId: " + groupId + ", replaceGroupRequestDto: " + replaceGroupRequestDto);
        HttpRequest httpRequest = this.replaceGroupRequestBuilder(servicePlanId, groupId, replaceGroupRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<CreateGroupResponseDto> localVarReturnType = new TypeReference<CreateGroupResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest replaceGroupRequestBuilder(String servicePlanId, String groupId, ReplaceGroupRequestDto replaceGroupRequestDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling replaceGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling replaceGroup");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups/{group_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{group_id\\}", URLParameterUtils.encodeParameterValue(groupId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, replaceGroupRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.PUT, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public CreateGroupResponseDto retrieveGroup(String servicePlanId, String groupId) throws ApiException {
        LOGGER.finest("[retrieveGroup] servicePlanId: " + servicePlanId + ", groupId: " + groupId);
        HttpRequest httpRequest = this.retrieveGroupRequestBuilder(servicePlanId, groupId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<CreateGroupResponseDto> localVarReturnType = new TypeReference<CreateGroupResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest retrieveGroupRequestBuilder(String servicePlanId, String groupId) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling retrieveGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling retrieveGroup");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups/{group_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{group_id\\}", URLParameterUtils.encodeParameterValue(groupId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public CreateGroupResponseDto updateGroup(String servicePlanId, String groupId, UpdateGroupRequestDto updateGroupRequestDto) throws ApiException {
        LOGGER.finest("[updateGroup] servicePlanId: " + servicePlanId + ", groupId: " + groupId + ", updateGroupRequestDto: " + updateGroupRequestDto);
        HttpRequest httpRequest = this.updateGroupRequestBuilder(servicePlanId, groupId, updateGroupRequestDto);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<CreateGroupResponseDto> localVarReturnType = new TypeReference<CreateGroupResponseDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest updateGroupRequestBuilder(String servicePlanId, String groupId, UpdateGroupRequestDto updateGroupRequestDto) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling updateGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling updateGroup");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/groups/{group_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{group_id\\}", URLParameterUtils.encodeParameterValue(groupId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList("application/json");
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = this.mapper.serialize(localVarContentTypes, updateGroupRequestDto);
        return new HttpRequest(localVarPath, HttpMethod.POST, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

