/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.sms.models.dto.v1.ApiInboundListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.InboundDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class InboundsApi {
    private static final Logger LOGGER = Logger.getLogger(InboundsApi.class.getName());
    private HttpClient httpClient;
    private ServerConfiguration serverConfiguration;
    private HttpMapper mapper;

    public InboundsApi(HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
        this.httpClient = httpClient;
        this.serverConfiguration = serverConfiguration;
        this.mapper = mapper;
    }

    public ApiInboundListDto listInboundMessages(String servicePlanId, Integer page, Integer pageSize, String to, String startDate, String endDate, String clientReference) throws ApiException {
        LOGGER.finest("[listInboundMessages] servicePlanId: " + servicePlanId + ", page: " + page + ", pageSize: " + pageSize + ", to: " + to + ", startDate: " + startDate + ", endDate: " + endDate + ", clientReference: " + clientReference);
        HttpRequest httpRequest = this.listInboundMessagesRequestBuilder(servicePlanId, page, pageSize, to, startDate, endDate, clientReference);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<ApiInboundListDto> localVarReturnType = new TypeReference<ApiInboundListDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest listInboundMessagesRequestBuilder(String servicePlanId, Integer page, Integer pageSize, String to, String startDate, String endDate, String clientReference) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling listInboundMessages");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/inbounds".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        if (null != page) {
            localVarQueryParams.add(new URLParameter("page", page, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != pageSize) {
            localVarQueryParams.add(new URLParameter("page_size", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != to) {
            localVarQueryParams.add(new URLParameter("to", to, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != startDate) {
            localVarQueryParams.add(new URLParameter("start_date", startDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != endDate) {
            localVarQueryParams.add(new URLParameter("end_date", endDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        if (null != clientReference) {
            localVarQueryParams.add(new URLParameter("client_reference", clientReference, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }

    public InboundDto retrieveInboundMessage(String servicePlanId, String inboundId) throws ApiException {
        LOGGER.finest("[retrieveInboundMessage] servicePlanId: " + servicePlanId + ", inboundId: " + inboundId);
        HttpRequest httpRequest = this.retrieveInboundMessageRequestBuilder(servicePlanId, inboundId);
        HttpResponse response = this.httpClient.invokeAPI(this.serverConfiguration, httpRequest);
        if (HttpStatus.isSuccessfulStatus(response.getCode())) {
            TypeReference<InboundDto> localVarReturnType = new TypeReference<InboundDto>(){};
            return this.mapper.deserialize(response, localVarReturnType);
        }
        throw ApiExceptionBuilder.build(response.getMessage(), response.getCode(), (Map)this.mapper.deserialize(response, new TypeReference<HashMap<String, ?>>(){}));
    }

    private HttpRequest retrieveInboundMessageRequestBuilder(String servicePlanId, String inboundId) throws ApiException {
        if (servicePlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'servicePlanId' when calling retrieveInboundMessage");
        }
        if (inboundId == null) {
            throw new ApiException(400, "Missing the required parameter 'inboundId' when calling retrieveInboundMessage");
        }
        String localVarPath = "/xms/v1/{service_plan_id}/inbounds/{inbound_id}".replaceAll("\\{service_plan_id\\}", URLParameterUtils.encodeParameterValue(servicePlanId.toString())).replaceAll("\\{inbound_id\\}", URLParameterUtils.encodeParameterValue(inboundId.toString()));
        ArrayList<URLParameter> localVarQueryParams = new ArrayList<URLParameter>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        List<String> localVarAccepts = Arrays.asList("application/json");
        List<String> localVarContentTypes = Arrays.asList(new String[0]);
        List<String> localVarAuthNames = Arrays.asList("BearerAuth");
        String serializedBody = null;
        return new HttpRequest(localVarPath, HttpMethod.GET, localVarQueryParams, serializedBody, localVarHeaderParams, localVarAccepts, localVarContentTypes, localVarAuthNames);
    }
}

