/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.adapters.converters;

import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.models.AbstractOpenApiSchema;
import com.sinch.sdk.domains.sms.models.Inbound;
import com.sinch.sdk.domains.sms.models.InboundBinary;
import com.sinch.sdk.domains.sms.models.InboundText;
import com.sinch.sdk.domains.sms.models.dto.v1.ApiInboundListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.InboundDto;
import com.sinch.sdk.domains.sms.models.dto.v1.MOBinaryDto;
import com.sinch.sdk.domains.sms.models.dto.v1.MOTextDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InboundsDtoConverter {
    public static Inbound<?> convert(AbstractOpenApiSchema dto) {
        Object obj = dto.getActualInstance();
        if (obj instanceof MOBinaryDto) {
            return InboundsDtoConverter.convert((MOBinaryDto)obj);
        }
        if (obj instanceof MOTextDto) {
            return InboundsDtoConverter.convert((MOTextDto)obj);
        }
        throw new ApiException("Unexpected class:" + obj.getClass().getName());
    }

    public static Collection<Inbound<?>> convert(ApiInboundListDto dto) {
        List<InboundDto> collection = dto.getInbounds();
        ArrayList pageContent = new ArrayList();
        if (null != collection) {
            for (InboundDto innerDto : collection) {
                Inbound<?> convert = InboundsDtoConverter.convert(innerDto);
                pageContent.add(convert);
            }
        }
        return pageContent;
    }

    public static InboundBinary convert(MOBinaryDto dto) {
        return ((InboundBinary.Builder)((InboundBinary.Builder)((InboundBinary.Builder)((InboundBinary.Builder)((InboundBinary.Builder)((InboundBinary.Builder)((InboundBinary.Builder)((InboundBinary.Builder)InboundBinary.builder().setBody(dto.getBody())).setFrom(dto.getFrom())).setId(dto.getId())).setReceivedAt(null != dto.getReceivedAt() ? dto.getReceivedAt().toInstant() : null)).setTo(dto.getTo())).setClientReference(dto.getClientReference())).setOperatorId(dto.getOperatorId())).setSentAt(null != dto.getSentAt() ? dto.getSentAt().toInstant() : null)).setUdh(dto.getUdh()).build();
    }

    public static InboundText convert(MOTextDto dto) {
        return ((InboundText.Builder)((InboundText.Builder)((InboundText.Builder)((InboundText.Builder)((InboundText.Builder)((InboundText.Builder)((InboundText.Builder)((InboundText.Builder)InboundText.builder().setBody(dto.getBody())).setFrom(dto.getFrom())).setId(dto.getId())).setReceivedAt(null != dto.getReceivedAt() ? dto.getReceivedAt().toInstant() : null)).setTo(dto.getTo())).setClientReference(dto.getClientReference())).setOperatorId(dto.getOperatorId())).setSentAt(null != dto.getSentAt() ? dto.getSentAt().toInstant() : null)).build();
    }
}

