/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class BaseBatch<T> {
    private final T body;
    private final Collection<String> to;
    private final String from;
    private final DeliveryReportType deliveryReport;
    private final Instant sendAt;
    private final Instant expireAt;
    private final String callbackUrl;
    private final String clientReference;
    private final Boolean feedbackEnabled;

    public BaseBatch(Collection<String> to, String from, T body, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl, String clientReference, Boolean feedbackEnabled) {
        Objects.requireNonNull(to);
        Objects.requireNonNull(body);
        this.to = to;
        this.from = from;
        this.body = body;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
        this.clientReference = clientReference;
        this.feedbackEnabled = feedbackEnabled;
    }

    public Collection<String> getTo() {
        return this.to;
    }

    public T getBody() {
        return this.body;
    }

    public Optional<String> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Optional<DeliveryReportType> getDeliveryReport() {
        return Optional.ofNullable(this.deliveryReport);
    }

    public Optional<Instant> getSendAt() {
        return Optional.ofNullable(this.sendAt);
    }

    public Optional<Instant> getExpireAt() {
        return Optional.ofNullable(this.expireAt);
    }

    public Optional<String> getCallbackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public Optional<String> getClientReference() {
        return Optional.ofNullable(this.clientReference);
    }

    public Optional<Boolean> isFeedbackEnabled() {
        return Optional.ofNullable(this.feedbackEnabled);
    }

    public String toString() {
        return "BaseBatch{body=" + this.body + ", to=" + this.to + ", from='" + this.from + '\'' + ", deliveryReportType=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl='" + this.callbackUrl + '\'' + ", clientReference='" + this.clientReference + '\'' + ", feedbackEnabled=" + this.feedbackEnabled + '}';
    }

    public static class BatchBuilder<T>
    extends Builder<T, BatchBuilder<T>> {
        @Override
        protected BatchBuilder<T> self() {
            return this;
        }
    }

    protected static class Builder<T, B extends Builder<T, B>> {
        public Collection<String> to;
        public String from;
        public T body;
        public DeliveryReportType deliveryReport;
        public Instant sendAt;
        public Instant expireAt;
        public String callbackUrl;
        public String clientReference;
        public Boolean feedbackEnabled;

        protected Builder() {
        }

        public B setTo(Collection<String> to) {
            this.to = to;
            return this.self();
        }

        public B setFrom(String from) {
            this.from = from;
            return this.self();
        }

        public B setBody(T body) {
            this.body = body;
            return this.self();
        }

        public B setDeliveryReport(DeliveryReportType deliveryReport) {
            this.deliveryReport = deliveryReport;
            return this.self();
        }

        public B setSendAt(Instant sendAt) {
            this.sendAt = sendAt;
            return this.self();
        }

        public B setExpireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this.self();
        }

        public B setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this.self();
        }

        public B setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this.self();
        }

        public B setFeedbackEnabled(Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
            return this.self();
        }

        public BaseBatch<T> build() {
            return new BaseBatch<T>(this.to, this.from, this.body, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.feedbackEnabled);
        }

        protected B self() {
            return (B)this;
        }
    }
}

