/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import java.util.Objects;
import java.util.Optional;

public abstract class BaseDeliveryReport {
    private final String batchId;
    private final String clientReference;

    public BaseDeliveryReport(String batchId, String clientReference) {
        Objects.requireNonNull(batchId);
        this.batchId = batchId;
        this.clientReference = clientReference;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public Optional<String> getClientReference() {
        return Optional.ofNullable(this.clientReference);
    }

    public String toString() {
        return "BaseDeliveryReport{batchId='" + this.batchId + '\'' + ", clientReference='" + this.clientReference + '\'' + '}';
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected String batchId;
        protected String clientReference;

        public B setBatchId(String batchId) {
            this.batchId = batchId;
            return this.self();
        }

        public B setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this.self();
        }

        protected B self() {
            return (B)this;
        }
    }
}

