/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import java.time.Instant;
import java.util.Collection;

public class Batch<T> {
    private final String id;
    private final Collection<String> to;
    private final String from;
    private final Boolean canceled;
    private final T body;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final DeliveryReportType deliveryReport;
    private final Instant sendAt;
    private final Instant expireAt;
    private final String callbackUrl;
    private final String clientReference;
    private final Boolean feedbackEnabled;

    public Batch(String id, Collection<String> to, String from, Boolean canceled, T body, Instant createdAt, Instant modifiedAt, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl, String clientReference, Boolean feedbackEnabled) {
        this.id = id;
        this.to = to;
        this.from = from;
        this.canceled = canceled;
        this.body = body;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
        this.clientReference = clientReference;
        this.feedbackEnabled = feedbackEnabled;
    }

    public static <T> BatchBuilder<T> batchBuilder() {
        return new BatchBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Collection<String> getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Boolean isCanceled() {
        return this.canceled;
    }

    public T getBody() {
        return this.body;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getModifiedAt() {
        return this.modifiedAt;
    }

    public DeliveryReportType getDeliveryReport() {
        return this.deliveryReport;
    }

    public Instant getSendAt() {
        return this.sendAt;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getClientReference() {
        return this.clientReference;
    }

    public Boolean isFeedbackEnabled() {
        return this.feedbackEnabled;
    }

    public String toString() {
        return "Batch{id='" + this.id + '\'' + ", to=" + this.to + ", from='" + this.from + '\'' + ", canceled=" + this.canceled + ", body=" + this.body + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", deliveryReportType=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl='" + this.callbackUrl + '\'' + ", clientReference='" + this.clientReference + '\'' + ", feedbackEnabled=" + this.feedbackEnabled + '}';
    }

    public static class BatchBuilder<T>
    extends Builder<T, BatchBuilder<T>> {
        @Override
        protected BatchBuilder<T> self() {
            return this;
        }
    }

    protected static class Builder<T, B extends Builder<T, B>> {
        String id;
        Collection<String> to;
        String from;
        Boolean canceled;
        T body;
        Instant createdAt;
        Instant modifiedAt;
        DeliveryReportType deliveryReport;
        Instant sendAt;
        Instant expireAt;
        String callbackUrl;
        String clientReference;
        Boolean feedbackEnabled;

        protected Builder() {
        }

        public B setId(String id) {
            this.id = id;
            return this.self();
        }

        public B setTo(Collection<String> to) {
            this.to = to;
            return this.self();
        }

        public B setFrom(String from) {
            this.from = from;
            return this.self();
        }

        public B setCanceled(Boolean canceled) {
            this.canceled = canceled;
            return this.self();
        }

        public B setBody(T body) {
            this.body = body;
            return this.self();
        }

        public B setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        public B setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this.self();
        }

        public B setDeliveryReport(DeliveryReportType deliveryReport) {
            this.deliveryReport = deliveryReport;
            return this.self();
        }

        public B setSendAt(Instant sendAt) {
            this.sendAt = sendAt;
            return this.self();
        }

        public B setExpireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this.self();
        }

        public B setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this.self();
        }

        public B setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this.self();
        }

        public B setFeedbackEnabled(Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
            return this.self();
        }

        public Batch<T> build() {
            return new Batch<T>(this.id, this.to, this.from, this.canceled, this.body, this.createdAt, this.modifiedAt, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.feedbackEnabled);
        }

        protected B self() {
            return (B)this;
        }
    }
}

