/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.domains.sms.models.Batch;
import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import com.sinch.sdk.domains.sms.models.Parameters;
import java.time.Instant;
import java.util.Collection;

public class BatchText
extends Batch<String> {
    private final Boolean flashMessage;
    private final Parameters parameters;
    private final Boolean truncateConcat;
    private final Integer maxNumberOfMessageParts;
    private final Integer fromTon;
    private final Integer fromNpi;

    public BatchText(String id, Collection<String> to, String from, Boolean canceled, String body, Instant createdAt, Instant modifiedAt, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl, String clientReference, Boolean flashMessage, Boolean feedbackEnabled, Parameters parameters, Boolean truncateConcat, Integer maxNumberOfMessageParts, Integer fromTon, Integer fromNpi) {
        super(id, to, from, canceled, body, createdAt, modifiedAt, deliveryReport, sendAt, expireAt, callbackUrl, clientReference, feedbackEnabled);
        this.flashMessage = flashMessage;
        this.parameters = parameters;
        this.truncateConcat = truncateConcat;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.fromTon = fromTon;
        this.fromNpi = fromNpi;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Boolean isFlashMessage() {
        return this.flashMessage;
    }

    public Boolean isTruncateConcat() {
        return this.truncateConcat;
    }

    public Integer getMaxNumberOfMessageParts() {
        return this.maxNumberOfMessageParts;
    }

    public Integer getFromTon() {
        return this.fromTon;
    }

    public Integer getFromNpi() {
        return this.fromNpi;
    }

    @Override
    public String toString() {
        return "BatchText{flashMessage=" + this.flashMessage + ", parameters=" + this.parameters + ", truncateConcat=" + this.truncateConcat + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", fromTon=" + this.fromTon + ", fromNpi=" + this.fromNpi + "} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Batch.Builder<String, Builder> {
        private Boolean flashMessage;
        private Parameters parameters;
        private Boolean truncateConcat;
        private Integer maxNumberOfMessageParts;
        private Integer fromTon;
        private Integer fromNpi;

        private Builder() {
        }

        public Builder setFlashMessage(Boolean flashMessage) {
            this.flashMessage = flashMessage;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setTruncateConcat(Boolean truncateConcat) {
            this.truncateConcat = truncateConcat;
            return this;
        }

        public Builder setMaxNumberOfMessageParts(Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return this;
        }

        public Builder setFromTon(Integer fromTon) {
            this.fromTon = fromTon;
            return this;
        }

        public Builder setFromNpi(Integer fromNpi) {
            this.fromNpi = fromNpi;
            return this;
        }

        public BatchText build() {
            return new BatchText(this.id, this.to, this.from, this.canceled, (String)this.body, this.createdAt, this.modifiedAt, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.flashMessage, this.feedbackEnabled, this.parameters, this.truncateConcat, this.maxNumberOfMessageParts, this.fromTon, this.fromNpi);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

