/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.domains.sms.models.BaseDeliveryReport;
import com.sinch.sdk.domains.sms.models.DeliveryReportErrorCode;
import com.sinch.sdk.domains.sms.models.DeliveryReportRecipientEncoding;
import com.sinch.sdk.domains.sms.models.DeliveryReportStatus;
import java.time.Instant;
import java.util.Optional;

public abstract class DeliveryReportRecipient
extends BaseDeliveryReport {
    private final Instant at;
    private final DeliveryReportErrorCode code;
    private final String recipient;
    private final DeliveryReportStatus status;
    private final String appliedOriginator;
    private final DeliveryReportRecipientEncoding encoding;
    private final Integer numberOfMessageParts;
    private final String operator;
    private final Instant operatorStatusAt;

    public DeliveryReportRecipient(String batchId, String clientReference, Instant at, DeliveryReportErrorCode code, String recipient, DeliveryReportStatus status, String appliedOriginator, DeliveryReportRecipientEncoding encoding, Integer numberOfMessageParts, String operator, Instant operatorStatusAt) {
        super(batchId, clientReference);
        this.at = at;
        this.code = code;
        this.recipient = recipient;
        this.status = status;
        this.appliedOriginator = appliedOriginator;
        this.encoding = encoding;
        this.numberOfMessageParts = numberOfMessageParts;
        this.operator = operator;
        this.operatorStatusAt = operatorStatusAt;
    }

    public Instant getAt() {
        return this.at;
    }

    public DeliveryReportErrorCode getCode() {
        return this.code;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public DeliveryReportStatus getStatus() {
        return this.status;
    }

    public Optional<String> getAppliedOriginator() {
        return Optional.ofNullable(this.appliedOriginator);
    }

    public Optional<DeliveryReportRecipientEncoding> getEncoding() {
        return Optional.ofNullable(this.encoding);
    }

    public Optional<Integer> getNumberOfMessageParts() {
        return Optional.ofNullable(this.numberOfMessageParts);
    }

    public Optional<String> getOperator() {
        return Optional.ofNullable(this.operator);
    }

    public Optional<Instant> getOperatorStatusAt() {
        return Optional.ofNullable(this.operatorStatusAt);
    }

    @Override
    public String toString() {
        return "DeliveryReportRecipient{at=" + this.at + ", code='" + this.code + '\'' + ", recipient='" + this.recipient + '\'' + ", status=" + this.status + ", appliedOriginator='" + this.appliedOriginator + '\'' + ", encoding='" + this.encoding + '\'' + ", numberOfMessageParts=" + this.numberOfMessageParts + ", operator='" + this.operator + '\'' + ", operatorStatusAt=" + this.operatorStatusAt + "} " + super.toString();
    }

    public static abstract class Builder<B extends Builder<B>>
    extends BaseDeliveryReport.Builder<B> {
        protected Instant at;
        protected DeliveryReportErrorCode code;
        protected String recipient;
        protected DeliveryReportStatus status;
        protected String appliedOriginator;
        protected DeliveryReportRecipientEncoding encoding;
        protected Integer numberOfMessageParts;
        protected String operator;
        protected Instant operatorStatusAt;

        public Builder<B> setAt(Instant at) {
            this.at = at;
            return this;
        }

        public Builder<B> setCode(DeliveryReportErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder<B> setRecipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder<B> setStatus(DeliveryReportStatus status) {
            this.status = status;
            return this;
        }

        public Builder<B> setAppliedOriginator(String appliedOriginator) {
            this.appliedOriginator = appliedOriginator;
            return this;
        }

        public Builder<B> setEncoding(DeliveryReportRecipientEncoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder<B> setNumberOfMessageParts(Integer numberOfMessageParts) {
            this.numberOfMessageParts = numberOfMessageParts;
            return this;
        }

        public Builder<B> setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        public Builder<B> setOperatorStatusAt(Instant operatorStatusAt) {
            this.operatorStatusAt = operatorStatusAt;
            return this;
        }

        public abstract DeliveryReportRecipient build();
    }
}

