/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.domains.sms.models.DeliveryReportStatus;
import java.util.Collection;

public class DeliveryReportStatusDetails {
    private final Integer code;
    private final Integer count;
    private final Collection<String> recipients;
    private final DeliveryReportStatus status;

    public DeliveryReportStatusDetails(Integer code, Integer count, Collection<String> recipients, String status) {
        this.code = code;
        this.count = count;
        this.recipients = recipients;
        this.status = DeliveryReportStatus.from(status);
    }

    public Integer getCode() {
        return this.code;
    }

    public Integer getCount() {
        return this.count;
    }

    public Collection<String> getRecipients() {
        return this.recipients;
    }

    public DeliveryReportStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return "DeliveryReportStatusDetails{code=" + this.code + ", count=" + this.count + ", recipients=" + this.recipients + ", status=" + this.status + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer code;
        private Integer count;
        private Collection<String> recipients;
        private DeliveryReportStatus status;

        private Builder() {
        }

        public Builder setCode(Integer code) {
            this.code = code;
            return this;
        }

        public Builder setCount(Integer count) {
            this.count = count;
            return this;
        }

        public Builder setRecipients(Collection<String> recipients) {
            this.recipients = recipients;
            return this;
        }

        public Builder setStatus(DeliveryReportStatus status) {
            this.status = status;
            return this;
        }

        public DeliveryReportStatusDetails build() {
            return new DeliveryReportStatusDetails(this.code, this.count, this.recipients, (String)this.status.value());
        }
    }
}

