/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.domains.sms.models.GroupAutoUpdate;
import java.time.Instant;
import java.util.Collection;

public class Group {
    private final String id;
    private final String name;
    private final Integer size;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Collection<String> childGroupIds;
    private final GroupAutoUpdate autoUpdate;

    public Group(String id, String name, Integer size, Instant createdAt, Instant modifiedAt, Collection<String> childGroupIds, GroupAutoUpdate autoUpdate) {
        this.id = id;
        this.name = name;
        this.size = size;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.childGroupIds = childGroupIds;
        this.autoUpdate = autoUpdate;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return this.size;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getModifiedAt() {
        return this.modifiedAt;
    }

    public Collection<String> getChildGroupIds() {
        return this.childGroupIds;
    }

    public GroupAutoUpdate getAutoUpdate() {
        return this.autoUpdate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Group{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", childGroupIds=" + this.childGroupIds + ", autoUpdate=" + this.autoUpdate + '}';
    }

    public static class Builder {
        String id;
        String name;
        Integer size;
        Instant createdAt;
        Instant modifiedAt;
        Collection<String> childGroupIds;
        GroupAutoUpdate autoUpdate;

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSize(Integer size) {
            this.size = size;
            return this;
        }

        public Builder setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder setChildGroupIds(Collection<String> childGroupIds) {
            this.childGroupIds = childGroupIds;
            return this;
        }

        public Builder setAutoUpdate(GroupAutoUpdate autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public Group build() {
            return new Group(this.id, this.name, this.size, this.createdAt, this.modifiedAt, this.childGroupIds, this.autoUpdate);
        }
    }
}

