/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import java.time.Instant;
import java.util.Optional;

public abstract class Inbound<T> {
    private final T body;
    private final String from;
    private final String id;
    private final Instant receivedAt;
    private final String to;
    private final String clientReference;
    private final String operatorId;
    private final Instant sentAt;

    public Inbound(T body, String from, String id, Instant receivedAt, String to, String clientReference, String operatorId, Instant sentAt) {
        this.body = body;
        this.from = from;
        this.id = id;
        this.receivedAt = receivedAt;
        this.to = to;
        this.clientReference = clientReference;
        this.operatorId = operatorId;
        this.sentAt = sentAt;
    }

    public T getBody() {
        return this.body;
    }

    public String getFrom() {
        return this.from;
    }

    public String getId() {
        return this.id;
    }

    public Instant getReceivedAt() {
        return this.receivedAt;
    }

    public String getTo() {
        return this.to;
    }

    public Optional<String> getClientReference() {
        return Optional.ofNullable(this.clientReference);
    }

    public Optional<String> getOperatorId() {
        return Optional.ofNullable(this.operatorId);
    }

    public Optional<Instant> getSentAt() {
        return Optional.ofNullable(this.sentAt);
    }

    public String toString() {
        return "Inbound{body=" + this.body + ", from='" + this.from + '\'' + ", id='" + this.id + '\'' + ", receivedAt=" + this.receivedAt + ", to='" + this.to + '\'' + ", clientReference='" + this.clientReference + '\'' + ", operatorId='" + this.operatorId + '\'' + ", sentAt=" + this.sentAt + '}';
    }

    public static abstract class Builder<T, B extends Builder<T, B>> {
        T body;
        String from;
        String id;
        Instant receivedAt;
        String to;
        String clientReference;
        String operatorId;
        Instant sentAt;

        public B setBody(T body) {
            this.body = body;
            return this.self();
        }

        public B setFrom(String from) {
            this.from = from;
            return this.self();
        }

        public B setId(String id) {
            this.id = id;
            return this.self();
        }

        public B setReceivedAt(Instant receivedAt) {
            this.receivedAt = receivedAt;
            return this.self();
        }

        public B setTo(String to) {
            this.to = to;
            return this.self();
        }

        public B setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this.self();
        }

        public B setOperatorId(String operatorId) {
            this.operatorId = operatorId;
            return this.self();
        }

        public B setSentAt(Instant sentAt) {
            this.sentAt = sentAt;
            return this.self();
        }

        protected B self() {
            return (B)this;
        }

        public abstract Inbound<?> build();
    }
}

