/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import java.util.Optional;

public class MediaBody {
    private final String message;
    private final String url;

    public MediaBody(String url, String message) {
        this.message = message;
        this.url = url;
    }

    public MediaBody(String url) {
        this(url, null);
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public String toString() {
        return "MediaBody{message='" + this.message + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private String url;

        private Builder() {
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public MediaBody build() {
            return new MediaBody(this.url, this.message);
        }
    }
}

