/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models;

import com.sinch.sdk.core.utils.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;

public class Parameters
extends HashMap<String, Entry> {
    public Parameters(Collection<Entry> list) {
        super(list.stream().collect(Collectors.toMap(entry -> ((Entry)entry).key, entry -> entry)));
    }

    public static class Entry {
        private final String key;
        private final Pair<String, String> value;
        private final String defaultValue;

        public Entry(String key, Pair<String, String> value, String defaultValue) {
            this.key = key;
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public Entry(String key, Pair<String, String> value) {
            this(key, value, null);
        }

        public String getKey() {
            return this.key;
        }

        public Pair<String, String> getValue() {
            return this.value;
        }

        public Optional<String> getDefaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public String toString() {
            return "Entry{key='" + this.key + '\'' + ", value=" + this.value + ", defaultValue=" + this.defaultValue + '}';
        }
    }
}

