/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sinch.sdk.domains.sms.models.dto.v1.MessageDeliveryStatusDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"batch_id", "statuses", "total_message_count", "type", "client_reference"})
public class DeliveryReportDto {
    public static final String JSON_PROPERTY_BATCH_ID = "batch_id";
    private String batchId;
    public static final String JSON_PROPERTY_STATUSES = "statuses";
    private List<MessageDeliveryStatusDto> statuses = new ArrayList<MessageDeliveryStatusDto>();
    public static final String JSON_PROPERTY_TOTAL_MESSAGE_COUNT = "total_message_count";
    private Integer totalMessageCount;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_CLIENT_REFERENCE = "client_reference";
    private String clientReference;

    public DeliveryReportDto() {
    }

    @JsonCreator
    public DeliveryReportDto(@JsonProperty(value="batch_id") String batchId) {
        this();
        this.batchId = batchId;
    }

    @JsonProperty(value="batch_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBatchId() {
        return this.batchId;
    }

    public DeliveryReportDto statuses(List<MessageDeliveryStatusDto> statuses) {
        this.statuses = statuses;
        return this;
    }

    public DeliveryReportDto addStatusesItem(MessageDeliveryStatusDto statusesItem) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<MessageDeliveryStatusDto>();
        }
        this.statuses.add(statusesItem);
        return this;
    }

    @JsonProperty(value="statuses")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<MessageDeliveryStatusDto> getStatuses() {
        return this.statuses;
    }

    @JsonProperty(value="statuses")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatuses(List<MessageDeliveryStatusDto> statuses) {
        this.statuses = statuses;
    }

    public DeliveryReportDto totalMessageCount(Integer totalMessageCount) {
        this.totalMessageCount = totalMessageCount;
        return this;
    }

    @JsonProperty(value="total_message_count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotalMessageCount() {
        return this.totalMessageCount;
    }

    @JsonProperty(value="total_message_count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalMessageCount(Integer totalMessageCount) {
        this.totalMessageCount = totalMessageCount;
    }

    public DeliveryReportDto type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public DeliveryReportDto clientReference(String clientReference) {
        this.clientReference = clientReference;
        return this;
    }

    @JsonProperty(value="client_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientReference() {
        return this.clientReference;
    }

    @JsonProperty(value="client_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientReference(String clientReference) {
        this.clientReference = clientReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryReportDto deliveryReport = (DeliveryReportDto)o;
        return Objects.equals(this.batchId, deliveryReport.batchId) && Objects.equals(this.statuses, deliveryReport.statuses) && Objects.equals(this.totalMessageCount, deliveryReport.totalMessageCount) && Objects.equals(this.type, deliveryReport.type) && Objects.equals(this.clientReference, deliveryReport.clientReference);
    }

    public int hashCode() {
        return Objects.hash(this.batchId, this.statuses, this.totalMessageCount, this.type, this.clientReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeliveryReportDto {\n");
        sb.append("    batchId: ").append(this.toIndentedString(this.batchId)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    totalMessageCount: ").append(this.toIndentedString(this.totalMessageCount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    clientReference: ").append(this.toIndentedString(this.clientReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SMS("delivery_report_sms"),
        MMS("delivery_report_mms"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

