/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sinch.sdk.domains.sms.models.dto.v1.MediaBodyDto;
import com.sinch.sdk.domains.sms.models.dto.v1.ParameterObjDto;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"to", "body", "from", "parameters", "type", "delivery_report", "send_at", "expire_at", "callback_url", "client_reference", "feedback_enabled", "strict_validation"})
public class MediaRequestDto {
    public static final String JSON_PROPERTY_TO = "to";
    private List<String> to = new ArrayList<String>();
    public static final String JSON_PROPERTY_BODY = "body";
    private MediaBodyDto body;
    public static final String JSON_PROPERTY_FROM = "from";
    private String from;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    private ParameterObjDto parameters;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_DELIVERY_REPORT = "delivery_report";
    private String deliveryReport = "none";
    public static final String JSON_PROPERTY_SEND_AT = "send_at";
    private OffsetDateTime sendAt;
    public static final String JSON_PROPERTY_EXPIRE_AT = "expire_at";
    private OffsetDateTime expireAt;
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_CLIENT_REFERENCE = "client_reference";
    private String clientReference;
    public static final String JSON_PROPERTY_FEEDBACK_ENABLED = "feedback_enabled";
    private Boolean feedbackEnabled = false;
    public static final String JSON_PROPERTY_STRICT_VALIDATION = "strict_validation";
    private Boolean strictValidation = false;

    public MediaRequestDto() {
    }

    @JsonCreator
    public MediaRequestDto(@JsonProperty(value="type") String type) {
        this();
        this.type = type;
    }

    public MediaRequestDto to(List<String> to) {
        this.to = to;
        return this;
    }

    public MediaRequestDto addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTo(List<String> to) {
        this.to = to;
    }

    public MediaRequestDto body(MediaBodyDto body) {
        this.body = body;
        return this;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MediaBodyDto getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBody(MediaBodyDto body) {
        this.body = body;
    }

    public MediaRequestDto from(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrom(String from) {
        this.from = from;
    }

    public MediaRequestDto parameters(ParameterObjDto parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ParameterObjDto getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameters(ParameterObjDto parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public MediaRequestDto deliveryReport(String deliveryReport) {
        this.deliveryReport = deliveryReport;
        return this;
    }

    @JsonProperty(value="delivery_report")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryReport() {
        return this.deliveryReport;
    }

    @JsonProperty(value="delivery_report")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryReport(String deliveryReport) {
        this.deliveryReport = deliveryReport;
    }

    public MediaRequestDto sendAt(OffsetDateTime sendAt) {
        this.sendAt = sendAt;
        return this;
    }

    @JsonProperty(value="send_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getSendAt() {
        return this.sendAt;
    }

    @JsonProperty(value="send_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendAt(OffsetDateTime sendAt) {
        this.sendAt = sendAt;
    }

    public MediaRequestDto expireAt(OffsetDateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @JsonProperty(value="expire_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @JsonProperty(value="expire_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpireAt(OffsetDateTime expireAt) {
        this.expireAt = expireAt;
    }

    public MediaRequestDto callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public MediaRequestDto clientReference(String clientReference) {
        this.clientReference = clientReference;
        return this;
    }

    @JsonProperty(value="client_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientReference() {
        return this.clientReference;
    }

    @JsonProperty(value="client_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientReference(String clientReference) {
        this.clientReference = clientReference;
    }

    public MediaRequestDto feedbackEnabled(Boolean feedbackEnabled) {
        this.feedbackEnabled = feedbackEnabled;
        return this;
    }

    @JsonProperty(value="feedback_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFeedbackEnabled() {
        return this.feedbackEnabled;
    }

    @JsonProperty(value="feedback_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeedbackEnabled(Boolean feedbackEnabled) {
        this.feedbackEnabled = feedbackEnabled;
    }

    public MediaRequestDto strictValidation(Boolean strictValidation) {
        this.strictValidation = strictValidation;
        return this;
    }

    @JsonProperty(value="strict_validation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStrictValidation() {
        return this.strictValidation;
    }

    @JsonProperty(value="strict_validation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStrictValidation(Boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaRequestDto mediaRequest = (MediaRequestDto)o;
        return Objects.equals(this.to, mediaRequest.to) && Objects.equals(this.body, mediaRequest.body) && Objects.equals(this.from, mediaRequest.from) && Objects.equals(this.parameters, mediaRequest.parameters) && Objects.equals(this.type, mediaRequest.type) && Objects.equals(this.deliveryReport, mediaRequest.deliveryReport) && Objects.equals(this.sendAt, mediaRequest.sendAt) && Objects.equals(this.expireAt, mediaRequest.expireAt) && Objects.equals(this.callbackUrl, mediaRequest.callbackUrl) && Objects.equals(this.clientReference, mediaRequest.clientReference) && Objects.equals(this.feedbackEnabled, mediaRequest.feedbackEnabled) && Objects.equals(this.strictValidation, mediaRequest.strictValidation);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.body, this.from, this.parameters, this.type, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.feedbackEnabled, this.strictValidation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaRequestDto {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    deliveryReport: ").append(this.toIndentedString(this.deliveryReport)).append("\n");
        sb.append("    sendAt: ").append(this.toIndentedString(this.sendAt)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    clientReference: ").append(this.toIndentedString(this.clientReference)).append("\n");
        sb.append("    feedbackEnabled: ").append(this.toIndentedString(this.feedbackEnabled)).append("\n");
        sb.append("    strictValidation: ").append(this.toIndentedString(this.strictValidation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MT_MEDIA("mt_media"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

