/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import java.time.Instant;
import java.util.Optional;

public class BatchesListRequestParameters {
    private final String from;
    private final Instant startDate;
    private final Instant endDate;
    private final String clientReference;
    private final Integer page;
    private final Integer pageSize;

    public BatchesListRequestParameters(String from, Instant startDate, Instant endDate, String clientReference, Integer page, Integer pageSize) {
        this.from = from;
        this.startDate = startDate;
        this.endDate = endDate;
        this.clientReference = clientReference;
        this.page = page;
        this.pageSize = pageSize;
    }

    public Optional<String> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Optional<Instant> getStartDate() {
        return Optional.ofNullable(this.startDate);
    }

    public Optional<Instant> getEndDate() {
        return Optional.ofNullable(this.endDate);
    }

    public Optional<String> getClientReference() {
        return Optional.ofNullable(this.clientReference);
    }

    public Optional<Integer> getPage() {
        return Optional.ofNullable(this.page);
    }

    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(this.pageSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BatchesListRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        String from;
        Instant startDate;
        Instant endDate;
        String clientReference;
        Integer page;
        Integer pageSize;

        private Builder() {
        }

        private Builder(BatchesListRequestParameters parameters) {
            this.from = parameters.from;
            this.startDate = parameters.startDate;
            this.endDate = parameters.endDate;
            this.clientReference = parameters.clientReference;
            this.page = parameters.page;
            this.pageSize = parameters.pageSize;
        }

        public Builder setFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder setStartDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setEndDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this;
        }

        public Builder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public BatchesListRequestParameters build() {
            return new BatchesListRequestParameters(this.from, this.startDate, this.endDate, this.clientReference, this.page, this.pageSize);
        }
    }
}

