/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.DeliveryReportStatus;
import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import java.util.Collection;
import java.util.Optional;

public class DeliveryReportBatchGetRequestParameters {
    private final DeliveryReportType type;
    private final Collection<DeliveryReportStatus> statuses;
    private final Collection<Integer> codes;

    public DeliveryReportBatchGetRequestParameters(DeliveryReportType type, Collection<DeliveryReportStatus> statuses, Collection<Integer> codes) {
        this.type = type;
        this.statuses = statuses;
        this.codes = codes;
    }

    public Optional<DeliveryReportType> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<Collection<DeliveryReportStatus>> geStatues() {
        return Optional.ofNullable(this.statuses);
    }

    public Optional<Collection<Integer>> getCodes() {
        return Optional.ofNullable(this.codes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeliveryReportBatchGetRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        DeliveryReportType type;
        Collection<DeliveryReportStatus> statuses;
        Collection<Integer> codes;

        private Builder() {
        }

        private Builder(DeliveryReportBatchGetRequestParameters parameters) {
            this.type = parameters.type;
            this.statuses = parameters.statuses;
            this.codes = parameters.codes;
        }

        public Builder setType(DeliveryReportType type) {
            this.type = type;
            return this;
        }

        public Builder setStatuses(Collection<DeliveryReportStatus> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder setCodes(Collection<Integer> codes) {
            this.codes = codes;
            return this;
        }

        public DeliveryReportBatchGetRequestParameters build() {
            return new DeliveryReportBatchGetRequestParameters(this.type, this.statuses, this.codes);
        }
    }
}

