/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.DeliveryReportErrorCode;
import com.sinch.sdk.domains.sms.models.DeliveryReportStatus;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class DeliveryReportListRequestParameters {
    private final Instant startDate;
    private final Instant endDate;
    private final String clientReference;
    private final Integer page;
    private final Integer pageSize;
    private final Collection<DeliveryReportStatus> statuses;
    private final Collection<DeliveryReportErrorCode> codes;

    public DeliveryReportListRequestParameters(Instant startDate, Instant endDate, String clientReference, Integer page, Integer pageSize, Collection<DeliveryReportStatus> statuses, Collection<DeliveryReportErrorCode> codes) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.clientReference = clientReference;
        this.page = page;
        this.pageSize = pageSize;
        this.statuses = statuses;
        this.codes = codes;
    }

    public Optional<Instant> getStartDate() {
        return Optional.ofNullable(this.startDate);
    }

    public Optional<Instant> getEndDate() {
        return Optional.ofNullable(this.endDate);
    }

    public Optional<String> getClientReference() {
        return Optional.ofNullable(this.clientReference);
    }

    public Optional<Integer> getPage() {
        return Optional.ofNullable(this.page);
    }

    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(this.pageSize);
    }

    public Optional<Collection<DeliveryReportStatus>> getStatuses() {
        return Optional.ofNullable(this.statuses);
    }

    public Optional<Collection<DeliveryReportErrorCode>> getCodes() {
        return Optional.ofNullable(this.codes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeliveryReportListRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        Instant startDate;
        Instant endDate;
        String clientReference;
        Integer page;
        Integer pageSize;
        Collection<DeliveryReportStatus> statuses;
        Collection<DeliveryReportErrorCode> codes;

        private Builder() {
        }

        private Builder(DeliveryReportListRequestParameters parameters) {
            this.startDate = parameters.startDate;
            this.endDate = parameters.endDate;
            this.clientReference = parameters.clientReference;
            this.page = parameters.page;
            this.pageSize = parameters.pageSize;
            this.statuses = parameters.statuses;
            this.codes = parameters.codes;
        }

        public Builder setStartDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setEndDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this;
        }

        public Builder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setStatuses(Collection<DeliveryReportStatus> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder setCodes(Collection<DeliveryReportErrorCode> codes) {
            this.codes = codes;
            return this;
        }

        public DeliveryReportListRequestParameters build() {
            return new DeliveryReportListRequestParameters(this.startDate, this.endDate, this.clientReference, this.page, this.pageSize, this.statuses, this.codes);
        }
    }
}

