/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import java.util.Collection;
import java.util.Optional;

public class GroupReplaceRequestParameters {
    private final String name;
    private final Collection<String> members;

    public GroupReplaceRequestParameters(String name, Collection<String> members) {
        this.name = name;
        this.members = members;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Collection<String>> getMembers() {
        return Optional.ofNullable(this.members);
    }

    public String toString() {
        return "GroupCreateRequestParameters{name='" + this.name + '\'' + ", members=" + this.members + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupReplaceRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        String name;
        Collection<String> members;

        private Builder() {
        }

        private Builder(GroupReplaceRequestParameters parameters) {
            this.name = parameters.getName().orElse(null);
            this.members = parameters.getMembers().orElse(null);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMembers(Collection<String> members) {
            this.members = members;
            return this;
        }

        public GroupReplaceRequestParameters build() {
            return new GroupReplaceRequestParameters(this.name, this.members);
        }
    }
}

