/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.GroupAutoUpdate;
import java.util.Collection;
import java.util.Optional;

public class GroupUpdateRequestParameters {
    private final String name;
    private final Collection<String> add;
    private final Collection<String> remove;
    private final String addFromGroup;
    private final String removeFromGroup;
    private final GroupAutoUpdate autoUpdate;

    public GroupUpdateRequestParameters(String name, Collection<String> add, Collection<String> remove, String addFromGroup, String removeFromGroup, GroupAutoUpdate autoUpdate) {
        this.name = name;
        this.add = add;
        this.remove = remove;
        this.addFromGroup = addFromGroup;
        this.removeFromGroup = removeFromGroup;
        this.autoUpdate = autoUpdate;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Collection<String>> getAdd() {
        return Optional.ofNullable(this.add);
    }

    public Optional<Collection<String>> getRemove() {
        return Optional.ofNullable(this.remove);
    }

    public Optional<String> getAddFromGroup() {
        return Optional.ofNullable(this.addFromGroup);
    }

    public Optional<String> getRemoveFromGroup() {
        return Optional.ofNullable(this.removeFromGroup);
    }

    public Optional<GroupAutoUpdate> getAutoUpdate() {
        return Optional.ofNullable(this.autoUpdate);
    }

    public String toString() {
        return "GroupUpdateRequestParameters{name='" + this.name + '\'' + ", add=" + this.add + ", remove=" + this.remove + ", addFromGroup='" + this.addFromGroup + '\'' + ", removeFromGroup='" + this.removeFromGroup + '\'' + ", autoUpdate=" + this.autoUpdate + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupUpdateRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        String name;
        Collection<String> add;
        Collection<String> remove;
        String addFromGroup;
        String removeFromGroup;
        GroupAutoUpdate autoUpdate;

        private Builder() {
        }

        private Builder(GroupUpdateRequestParameters parameters) {
            this.name = parameters.getName().orElse(null);
            this.add = parameters.getAdd().orElse(null);
            this.remove = parameters.getRemove().orElse(null);
            this.addFromGroup = parameters.getAddFromGroup().orElse(null);
            this.removeFromGroup = parameters.getRemoveFromGroup().orElse(null);
            this.autoUpdate = parameters.getAutoUpdate().orElse(null);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAdd(Collection<String> add) {
            this.add = add;
            return this;
        }

        public Builder setRemove(Collection<String> remove) {
            this.remove = remove;
            return this;
        }

        public Builder setAddFromGroup(String addFromGroup) {
            this.addFromGroup = addFromGroup;
            return this;
        }

        public Builder setRemoveFromGroup(String removeFromGroup) {
            this.removeFromGroup = removeFromGroup;
            return this;
        }

        public Builder setAutoUpdate(GroupAutoUpdate autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public GroupUpdateRequestParameters build() {
            return new GroupUpdateRequestParameters(this.name, this.add, this.remove, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
        }
    }
}

