/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import java.util.Optional;

public class GroupsListRequestParameters {
    private final Integer page;
    private final Integer pageSize;

    public GroupsListRequestParameters(Integer page, Integer pageSize) {
        this.page = page;
        this.pageSize = pageSize;
    }

    public Optional<Integer> getPage() {
        return Optional.ofNullable(this.page);
    }

    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(this.pageSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupsListRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        Integer page;
        Integer pageSize;

        private Builder() {
        }

        private Builder(GroupsListRequestParameters parameters) {
            this.page = parameters.page;
            this.pageSize = parameters.pageSize;
        }

        public Builder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GroupsListRequestParameters build() {
            return new GroupsListRequestParameters(this.page, this.pageSize);
        }
    }
}

