/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class InboundsListRequestParameters {
    private final Instant startDate;
    private final Instant endDate;
    private final String clientReference;
    private final Integer page;
    private final Integer pageSize;
    private final Collection<String> to;

    public InboundsListRequestParameters(Instant startDate, Instant endDate, String clientReference, Integer page, Integer pageSize, Collection<String> to) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.clientReference = clientReference;
        this.page = page;
        this.pageSize = pageSize;
        this.to = to;
    }

    public Optional<Instant> getStartDate() {
        return Optional.ofNullable(this.startDate);
    }

    public Optional<Instant> getEndDate() {
        return Optional.ofNullable(this.endDate);
    }

    public Optional<String> getClientReference() {
        return Optional.ofNullable(this.clientReference);
    }

    public Optional<Integer> getPage() {
        return Optional.ofNullable(this.page);
    }

    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(this.pageSize);
    }

    public Optional<Collection<String>> getTo() {
        return Optional.ofNullable(this.to);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InboundsListRequestParameters parameters) {
        return new Builder(parameters);
    }

    public static class Builder {
        Instant startDate;
        Instant endDate;
        String clientReference;
        Integer page;
        Integer pageSize;
        Collection<String> to;

        private Builder() {
        }

        private Builder(InboundsListRequestParameters parameters) {
            this.startDate = parameters.startDate;
            this.endDate = parameters.endDate;
            this.clientReference = parameters.clientReference;
            this.page = parameters.page;
            this.pageSize = parameters.pageSize;
            this.to = parameters.to;
        }

        public Builder setStartDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setEndDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder setClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this;
        }

        public Builder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setTo(Collection<String> to) {
            this.to = to;
            return this;
        }

        public InboundsListRequestParameters build() {
            return new InboundsListRequestParameters(this.startDate, this.endDate, this.clientReference, this.page, this.pageSize, this.to);
        }
    }
}

