/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.BaseBatch;
import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class SendSmsBatchBinaryRequest
extends BaseBatch<String> {
    private final Boolean flashMessage;
    private final Boolean truncateConcat;
    private final Integer maxNumberOfMessageParts;
    private final Integer fromTon;
    private final Integer fromNpi;
    private final String udh;

    public SendSmsBatchBinaryRequest(Collection<String> to, String from, String body, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl, String clientReference, Boolean flashMessage, Boolean feedbackEnabled, Boolean truncateConcat, Integer maxNumberOfMessageParts, Integer fromTon, Integer fromNpi, String udh) {
        super(to, from, body, deliveryReport, sendAt, expireAt, callbackUrl, clientReference, feedbackEnabled);
        this.flashMessage = flashMessage;
        this.truncateConcat = truncateConcat;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.fromTon = fromTon;
        this.fromNpi = fromNpi;
        this.udh = udh;
    }

    public Optional<Boolean> isFlashMessage() {
        return Optional.ofNullable(this.flashMessage);
    }

    public Optional<Boolean> isTruncateConcat() {
        return Optional.ofNullable(this.truncateConcat);
    }

    public Optional<Integer> getMaxNumberOfMessageParts() {
        return Optional.ofNullable(this.maxNumberOfMessageParts);
    }

    public Optional<Integer> getFromTon() {
        return Optional.ofNullable(this.fromTon);
    }

    public Optional<Integer> getFromNpi() {
        return Optional.ofNullable(this.fromNpi);
    }

    public String getUdh() {
        return this.udh;
    }

    @Override
    public String toString() {
        return "SendSmsBatchBinaryRequest{flashMessage=" + this.flashMessage + ", truncateConcat=" + this.truncateConcat + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", fromTon=" + this.fromTon + ", fromNpi=" + this.fromNpi + ", udh='" + this.udh + '\'' + ", base='} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseBatch.Builder<String, Builder> {
        private Boolean flashMessage;
        private Boolean truncateConcat;
        private Integer maxNumberOfMessageParts;
        private Integer fromTon;
        private Integer fromNpi;
        private String udh;

        private Builder() {
        }

        public Builder setFlashMessage(boolean flashMessage) {
            this.flashMessage = flashMessage;
            return this;
        }

        public Builder setTruncateConcat(boolean truncateConcat) {
            this.truncateConcat = truncateConcat;
            return this;
        }

        public Builder setMaxNumberOfMessageParts(int maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return this;
        }

        public Builder setFromTon(int fromTon) {
            this.fromTon = fromTon;
            return this;
        }

        public Builder setFromNpi(int fromNpi) {
            this.fromNpi = fromNpi;
            return this;
        }

        public Builder setUdh(String udh) {
            this.udh = udh;
            return this;
        }

        public SendSmsBatchBinaryRequest build() {
            return new SendSmsBatchBinaryRequest(this.to, this.from, (String)this.body, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.flashMessage, this.feedbackEnabled, this.truncateConcat, this.maxNumberOfMessageParts, this.fromTon, this.fromNpi, this.udh);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

