/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.BaseBatch;
import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import com.sinch.sdk.domains.sms.models.MediaBody;
import com.sinch.sdk.domains.sms.models.Parameters;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class SendSmsBatchMediaRequest
extends BaseBatch<MediaBody> {
    private final Parameters parameters;
    private final Boolean strictValidation;

    public SendSmsBatchMediaRequest(Collection<String> to, String from, MediaBody body, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl, String clientReference, Boolean feedbackEnabled, Parameters parameters, Boolean strictValidation) {
        super(to, from, body, deliveryReport, sendAt, expireAt, callbackUrl, clientReference, feedbackEnabled);
        this.parameters = parameters;
        this.strictValidation = strictValidation;
    }

    public Optional<Parameters> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<Boolean> isStrictValidation() {
        return Optional.ofNullable(this.strictValidation);
    }

    @Override
    public String toString() {
        return "SendSmsBatchMediaRequest{parameters=" + this.parameters + ", strictValidation=" + this.strictValidation + ", base='} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseBatch.Builder<MediaBody, Builder> {
        private Parameters parameters;
        private Boolean strictValidation;

        private Builder() {
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setStrictValidation(Boolean strictValidation) {
            this.strictValidation = strictValidation;
            return this;
        }

        public SendSmsBatchMediaRequest build() {
            return new SendSmsBatchMediaRequest(this.to, this.from, (MediaBody)this.body, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.feedbackEnabled, this.parameters, this.strictValidation);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

