/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.BaseBatch;
import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import com.sinch.sdk.domains.sms.models.Parameters;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class SendSmsBatchTextRequest
extends BaseBatch<String> {
    private final Boolean flashMessage;
    private final Parameters parameters;
    private final Boolean truncateConcat;
    private final Integer maxNumberOfMessageParts;
    private final Integer fromTon;
    private final Integer fromNpi;

    public SendSmsBatchTextRequest(Collection<String> to, String from, String body, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl, String clientReference, Boolean flashMessage, Boolean feedbackEnabled, Parameters parameters, Boolean truncateConcat, Integer maxNumberOfMessageParts, Integer fromTon, Integer fromNpi) {
        super(to, from, body, deliveryReport, sendAt, expireAt, callbackUrl, clientReference, feedbackEnabled);
        this.flashMessage = flashMessage;
        this.parameters = parameters;
        this.truncateConcat = truncateConcat;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.fromTon = fromTon;
        this.fromNpi = fromNpi;
    }

    public Optional<Parameters> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<Boolean> isFlashMessage() {
        return Optional.ofNullable(this.flashMessage);
    }

    public Optional<Boolean> isTruncateConcat() {
        return Optional.ofNullable(this.truncateConcat);
    }

    public Optional<Integer> getMaxNumberOfMessageParts() {
        return Optional.ofNullable(this.maxNumberOfMessageParts);
    }

    public Optional<Integer> getFromTon() {
        return Optional.ofNullable(this.fromTon);
    }

    public Optional<Integer> getFromNpi() {
        return Optional.ofNullable(this.fromNpi);
    }

    @Override
    public String toString() {
        return "SendSmsBatchTextRequest{flashMessage=" + this.flashMessage + ", parameters=" + this.parameters + ", truncateConcat=" + this.truncateConcat + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", fromTon=" + this.fromTon + ", fromNpi=" + this.fromNpi + "} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseBatch.Builder<String, Builder> {
        private Boolean flashMessage;
        private Parameters parameters;
        private Boolean truncateConcat;
        private Integer maxNumberOfMessageParts;
        private Integer fromTon;
        private Integer fromNpi;

        private Builder() {
        }

        public Builder setFlashMessage(boolean flashMessage) {
            this.flashMessage = flashMessage;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setTruncateConcat(Boolean truncateConcat) {
            this.truncateConcat = truncateConcat;
            return this;
        }

        public Builder setMaxNumberOfMessageParts(Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return this;
        }

        public Builder setFromTon(Integer fromTon) {
            this.fromTon = fromTon;
            return this;
        }

        public Builder setFromNpi(Integer fromNpi) {
            this.fromNpi = fromNpi;
            return this;
        }

        public SendSmsBatchTextRequest build() {
            return new SendSmsBatchTextRequest(this.to, this.from, (String)this.body, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.clientReference, this.flashMessage, this.feedbackEnabled, this.parameters, this.truncateConcat, this.maxNumberOfMessageParts, this.fromTon, this.fromNpi);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

