/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.requests;

import com.sinch.sdk.domains.sms.models.DeliveryReportType;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class UpdateBaseBatchRequest<T> {
    private final String from;
    private final T body;
    private final Collection<String> toAdd;
    private final Collection<String> toRemove;
    private final DeliveryReportType deliveryReport;
    private final Instant sendAt;
    private final Instant expireAt;
    private final String callbackUrl;

    public UpdateBaseBatchRequest(Collection<String> toAdd, Collection<String> toRemove, String from, T body, DeliveryReportType deliveryReport, Instant sendAt, Instant expireAt, String callbackUrl) {
        this.toAdd = toAdd;
        this.toRemove = toRemove;
        this.from = from;
        this.body = body;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
    }

    public static <T> BatchBuilder<T> batchBuilder() {
        return new BatchBuilder();
    }

    public Optional<Collection<String>> getToAdd() {
        return Optional.ofNullable(this.toAdd);
    }

    public Optional<Collection<String>> getToRemove() {
        return Optional.ofNullable(this.toRemove);
    }

    public Optional<T> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Optional<DeliveryReportType> getDeliveryReport() {
        return Optional.ofNullable(this.deliveryReport);
    }

    public Optional<Instant> getSendAt() {
        return Optional.ofNullable(this.sendAt);
    }

    public Optional<Instant> getExpireAt() {
        return Optional.ofNullable(this.expireAt);
    }

    public Optional<String> getCallbackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public String toString() {
        return "UpdateBaseBatchRequest{from='" + this.from + '\'' + ", body=" + this.body + ", toAdd=" + this.toAdd + ", toRemove=" + this.toRemove + ", deliveryReportType=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl='" + this.callbackUrl + '\'' + '}';
    }

    public static class BatchBuilder<T>
    extends Builder<T, BatchBuilder<T>> {
        @Override
        protected BatchBuilder<T> self() {
            return this;
        }
    }

    protected static class Builder<T, B extends Builder<T, B>> {
        public Collection<String> toAdd;
        public Collection<String> toRemove;
        public String from;
        public T body;
        public DeliveryReportType deliveryReportType;
        public Instant sendAt;
        public Instant expireAt;
        public String callbackUrl;

        protected Builder() {
        }

        public B setToAdd(Collection<String> toAdd) {
            this.toAdd = toAdd;
            return this.self();
        }

        public B setToRemove(Collection<String> toRemove) {
            this.toRemove = toRemove;
            return this.self();
        }

        public B setFrom(String from) {
            this.from = from;
            return this.self();
        }

        public B setBody(T body) {
            this.body = body;
            return this.self();
        }

        public B setDeliveryReport(DeliveryReportType deliveryReportType) {
            this.deliveryReportType = deliveryReportType;
            return this.self();
        }

        public B setSendAt(Instant sendAt) {
            this.sendAt = sendAt;
            return this.self();
        }

        public B setExpireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this.self();
        }

        public B setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this.self();
        }

        public UpdateBaseBatchRequest<T> build() {
            return new UpdateBaseBatchRequest<T>(this.toAdd, this.toRemove, this.from, this.body, this.deliveryReportType, this.sendAt, this.expireAt, this.callbackUrl);
        }

        protected B self() {
            return (B)this;
        }
    }
}

