/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.responses;

import com.sinch.sdk.core.models.pagination.ListResponse;
import com.sinch.sdk.core.models.pagination.Page;
import com.sinch.sdk.domains.sms.BatchesService;
import com.sinch.sdk.domains.sms.models.Batch;
import com.sinch.sdk.domains.sms.models.requests.BatchesListRequestParameters;
import java.util.Collection;
import java.util.NoSuchElementException;

public class BatchesListResponse
extends ListResponse<Batch<?>> {
    private final Page<BatchesListRequestParameters, Batch<?>, Integer> page;
    private final BatchesService service;
    private BatchesListResponse nextPage;

    public BatchesListResponse(BatchesService service, Page<BatchesListRequestParameters, Batch<?>, Integer> page) {
        this.service = service;
        this.page = page;
    }

    @Override
    public boolean hasNextPage() {
        if (null == this.nextPage) {
            BatchesListRequestParameters.Builder newParameters = BatchesListRequestParameters.builder(this.page.getParameters());
            newParameters.setPage(this.page.getNextPageToken());
            this.nextPage = this.service.list(newParameters.build());
        }
        return null != this.nextPage.getContent() && !this.nextPage.getContent().isEmpty();
    }

    public BatchesListResponse nextPage() {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Reached the last page of the API response");
        }
        BatchesListResponse response = this.nextPage;
        this.nextPage = null;
        return response;
    }

    @Override
    public Collection<Batch<?>> getContent() {
        return this.page.getEntities();
    }

    public String toString() {
        return "BatchesListResponse{page=" + this.page + '}';
    }
}

