/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.responses;

import com.sinch.sdk.core.models.pagination.ListResponse;
import com.sinch.sdk.core.models.pagination.Page;
import com.sinch.sdk.domains.sms.DeliveryReportsService;
import com.sinch.sdk.domains.sms.models.DeliveryReportRecipient;
import com.sinch.sdk.domains.sms.models.requests.DeliveryReportListRequestParameters;
import java.util.Collection;
import java.util.NoSuchElementException;

public class DeliveryReportsListResponse
extends ListResponse<DeliveryReportRecipient> {
    private final Page<DeliveryReportListRequestParameters, DeliveryReportRecipient, Integer> page;
    private final DeliveryReportsService service;
    private DeliveryReportsListResponse nextPage;

    public DeliveryReportsListResponse(DeliveryReportsService service, Page<DeliveryReportListRequestParameters, DeliveryReportRecipient, Integer> page) {
        this.service = service;
        this.page = page;
    }

    @Override
    public boolean hasNextPage() {
        if (null == this.nextPage) {
            DeliveryReportListRequestParameters.Builder newParameters = DeliveryReportListRequestParameters.builder(this.page.getParameters());
            newParameters.setPage(this.page.getNextPageToken());
            this.nextPage = this.service.list(newParameters.build());
        }
        return null != this.nextPage.getContent() && !this.nextPage.getContent().isEmpty();
    }

    public DeliveryReportsListResponse nextPage() {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Reached the last page of the API response");
        }
        DeliveryReportsListResponse response = this.nextPage;
        this.nextPage = null;
        return response;
    }

    @Override
    public Collection<DeliveryReportRecipient> getContent() {
        return this.page.getEntities();
    }

    public String toString() {
        return "DeliveryReportsListResponse{page=" + this.page + '}';
    }
}

