/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.responses;

import com.sinch.sdk.core.models.pagination.ListResponse;
import com.sinch.sdk.core.models.pagination.Page;
import com.sinch.sdk.domains.sms.GroupsService;
import com.sinch.sdk.domains.sms.models.Group;
import com.sinch.sdk.domains.sms.models.requests.GroupsListRequestParameters;
import java.util.Collection;
import java.util.NoSuchElementException;

public class GroupsListResponse
extends ListResponse<Group> {
    private final Page<GroupsListRequestParameters, Group, Integer> page;
    private final GroupsService service;
    private GroupsListResponse nextPage;

    public GroupsListResponse(GroupsService service, Page<GroupsListRequestParameters, Group, Integer> page) {
        this.service = service;
        this.page = page;
    }

    @Override
    public boolean hasNextPage() {
        if (null == this.nextPage) {
            GroupsListRequestParameters.Builder newParameters = GroupsListRequestParameters.builder(this.page.getParameters());
            newParameters.setPage(this.page.getNextPageToken());
            this.nextPage = this.service.list(newParameters.build());
        }
        return null != this.nextPage.getContent() && !this.nextPage.getContent().isEmpty();
    }

    public GroupsListResponse nextPage() {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Reached the last page of the API response");
        }
        GroupsListResponse response = this.nextPage;
        this.nextPage = null;
        return response;
    }

    @Override
    public Collection<Group> getContent() {
        return this.page.getEntities();
    }

    public String toString() {
        return "GroupsListResponse{page=" + this.page + '}';
    }
}

