/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.domains.sms.models.responses;

import com.sinch.sdk.core.models.pagination.ListResponse;
import com.sinch.sdk.core.models.pagination.Page;
import com.sinch.sdk.domains.sms.InboundsService;
import com.sinch.sdk.domains.sms.models.Inbound;
import com.sinch.sdk.domains.sms.models.requests.InboundsListRequestParameters;
import java.util.Collection;
import java.util.NoSuchElementException;

public class InboundsListResponse
extends ListResponse<Inbound<?>> {
    private final Page<InboundsListRequestParameters, Inbound<?>, Integer> page;
    private final InboundsService service;
    private InboundsListResponse nextPage;

    public InboundsListResponse(InboundsService service, Page<InboundsListRequestParameters, Inbound<?>, Integer> page) {
        this.service = service;
        this.page = page;
    }

    @Override
    public boolean hasNextPage() {
        if (null == this.nextPage) {
            InboundsListRequestParameters.Builder newParameters = InboundsListRequestParameters.builder(this.page.getParameters());
            newParameters.setPage(this.page.getNextPageToken());
            this.nextPage = this.service.list(newParameters.build());
        }
        return null != this.nextPage.getContent() && !this.nextPage.getContent().isEmpty();
    }

    public InboundsListResponse nextPage() {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Reached the last page of the API response");
        }
        InboundsListResponse response = this.nextPage;
        this.nextPage = null;
        return response;
    }

    @Override
    public Collection<Inbound<?>> getContent() {
        return this.page.getEntities();
    }

    public String toString() {
        return "InboundsListResponse{page=" + this.page + '}';
    }
}

