/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.http;

import com.sinch.sdk.auth.AuthManager;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;

public class HttpClientApache
implements HttpClient {
    private static final Logger LOGGER = Logger.getLogger(HttpClientApache.class.getName());
    private static final String AUTHORIZATION_HEADER_KEYWORD = "Authorization";
    private final Map<String, AuthManager> authManagers;
    private Map<String, String> headersToBeAdded;
    private CloseableHttpClient client = HttpClients.createDefault();

    public HttpClientApache(Map<String, AuthManager> authManagers) {
        this.authManagers = authManagers;
    }

    @Override
    public void setRequestHeaders(Map<String, String> headers) {
        this.headersToBeAdded = headers;
    }

    private static HttpResponse processResponse(ClassicHttpResponse response) throws IOException {
        int statusCode = response.getCode();
        Map<String, List<String>> headers = HttpClientApache.transformResponseHeaders(response.getHeaders());
        String message = response.getReasonPhrase();
        LOGGER.finest("response: " + statusCode + ", headers:" + headers);
        if (statusCode == 204) {
            return new HttpResponse(statusCode, message, headers, null);
        }
        HttpEntity entity = response.getEntity();
        Scanner s = new Scanner(entity.getContent()).useDelimiter("\\A");
        String content = s.hasNext() ? s.next() : "";
        return new HttpResponse(statusCode, message, headers, content.getBytes(StandardCharsets.UTF_8));
    }

    private static Map<String, List<String>> transformResponseHeaders(Header[] headers) {
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
        for (Header header : headers) {
            ArrayList<String> valuesList = (ArrayList<String>)headersMap.get(header.getName());
            if (valuesList != null) {
                valuesList.add(header.getValue());
                continue;
            }
            valuesList = new ArrayList<String>();
            valuesList.add(header.getValue());
            headersMap.put(header.getName(), valuesList);
        }
        return headersMap;
    }

    @Override
    public HttpResponse invokeAPI(ServerConfiguration serverConfiguration, HttpRequest httpRequest) throws ApiException {
        try {
            boolean couldRetryRequest;
            String path = serverConfiguration.getUrl() + httpRequest.getPath().orElse("");
            HttpMethod method = httpRequest.getMethod();
            Collection<URLParameter> queryParameters = httpRequest.getQueryParameters();
            String body = httpRequest.getBody();
            Map<String, String> headerParams = httpRequest.getHeaderParams();
            Collection<String> accept = httpRequest.getAccept();
            Collection<String> contentType = httpRequest.getContentType();
            Collection<String> authNames = httpRequest.getAuthNames();
            LOGGER.fine("Invoke '" + (Object)((Object)method) + "' onto '" + path + "'");
            LOGGER.fine("queryParameters: " + queryParameters);
            LOGGER.fine("body: " + body);
            LOGGER.fine("headerParams: " + headerParams);
            LOGGER.fine("accept: " + accept);
            LOGGER.fine("contentType: " + contentType);
            LOGGER.fine("authNames: " + authNames);
            ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create((String)method.name());
            this.setUri(requestBuilder, path, queryParameters);
            this.addBody(requestBuilder, body);
            this.addCollectionHeader(requestBuilder, "Content-Type", contentType);
            this.addCollectionHeader(requestBuilder, "Accept", accept);
            this.addHeaders(requestBuilder, headerParams);
            this.addHeaders(requestBuilder, this.headersToBeAdded);
            this.addAuth(requestBuilder, authNames);
            ClassicHttpRequest request = requestBuilder.build();
            HttpResponse response = this.processRequest(this.client, request);
            LOGGER.finest("connection response: " + response);
            if (response.getCode() == HttpStatus.UNAUTHORIZED.intValue() && (couldRetryRequest = this.processUnauthorizedResponse(httpRequest, response))) {
                this.addAuth(requestBuilder, authNames);
                request = requestBuilder.build();
                response = this.processRequest(this.client, request);
                LOGGER.finest("connection response on retry: " + response);
            }
            return response;
        }
        catch (Exception e) {
            LOGGER.severe("Error:" + e);
            throw new ApiException(e);
        }
    }

    private boolean processUnauthorizedResponse(HttpRequest request, HttpResponse response) {
        AuthManager bearerAuthManager = this.authManagers.get("BearerAuth");
        Collection<String> auths = request.getAuthNames();
        if (null == bearerAuthManager || !auths.contains("BearerAuth")) {
            return false;
        }
        Map<String, List<String>> responseHeaders = response.getHeaders();
        Collection header = responseHeaders.get("www-authenticate");
        boolean headerPresent = header.stream().anyMatch(e -> e.contains("expired"));
        if (headerPresent) {
            bearerAuthManager.resetToken();
        }
        return headerPresent;
    }

    private void setUri(ClassicRequestBuilder requestBuilder, String path, Collection<URLParameter> parameters) {
        if (null == parameters || parameters.isEmpty()) {
            requestBuilder.setUri(path);
            return;
        }
        String requestParameters = "?" + URLParameterUtils.encodeParametersAsString(parameters);
        LOGGER.finest("Request parameters: " + requestParameters);
        requestBuilder.setUri(path + requestParameters);
    }

    private void addBody(ClassicRequestBuilder requestBuilder, String body) {
        if (null != body) {
            requestBuilder.setEntity((HttpEntity)new StringEntity(body));
        }
    }

    private void addCollectionHeader(ClassicRequestBuilder requestBuilder, String header, Collection<String> values) {
        if (null != values && !values.isEmpty()) {
            requestBuilder.setHeader(header, String.join((CharSequence)",", values));
        }
    }

    private void addHeaders(ClassicRequestBuilder requestBuilder, Map<String, String> headers) {
        if (null == headers) {
            return;
        }
        headers.entrySet().iterator().forEachRemaining(f -> requestBuilder.setHeader((String)f.getKey(), (String)f.getValue()));
    }

    private void addAuth(ClassicRequestBuilder requestBuilder, Collection<String> values) {
        if (null == values || values.isEmpty()) {
            return;
        }
        for (String entry : values) {
            if (this.authManagers.containsKey(entry)) {
                AuthManager authManager = this.authManagers.get(entry);
                requestBuilder.setHeader(AUTHORIZATION_HEADER_KEYWORD, authManager.getAuthorizationHeaderValue());
                return;
            }
            LOGGER.info("Ignore unknown authentication value: '" + entry + "'");
        }
    }

    private HttpResponse processRequest(CloseableHttpClient client, ClassicHttpRequest request) throws IOException {
        return (HttpResponse)client.execute(request, HttpClientApache::processResponse);
    }

    @Override
    public boolean isClosed() {
        return null == this.client;
    }

    @Override
    public void close() throws Exception {
        if (!this.isClosed()) {
            try {
                this.client.close();
            }
            finally {
                this.client = null;
            }
        }
    }
}

