/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.models;

import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.models.SMSRegion;

public class Configuration {
    private final String keyId;
    private final String keySecret;
    private final String projectId;
    private final String oauthUrl;
    private final String numbersUrl;
    private final SMSRegion smsRegion;
    private final String smsUrl;

    private Configuration(String keyId, String keySecret, String projectId, String oauthUrl, String numbersUrl, SMSRegion smsRegion, String smsUrl) {
        this.keyId = keyId;
        this.keySecret = keySecret;
        this.projectId = projectId;
        this.oauthUrl = oauthUrl;
        this.numbersUrl = numbersUrl;
        this.smsRegion = null == smsRegion ? SMSRegion.US : smsRegion;
        this.smsUrl = smsUrl;
    }

    public String toString() {
        return "Configuration{keyId=..., keySecret=..., projectId=..., oAuthUrl='" + this.oauthUrl + '\'' + ", numbersUrl='" + this.numbersUrl + '\'' + ", smsRegion='" + this.smsRegion + '\'' + ", smsUrl='" + this.smsUrl + '\'' + "}";
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeySecret() {
        return this.keySecret;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public ServerConfiguration getOAuthServer() {
        return new ServerConfiguration(this.getOAuthUrl());
    }

    public String getOAuthUrl() {
        return this.oauthUrl;
    }

    public ServerConfiguration getNumbersServer() {
        return new ServerConfiguration(this.getNumbersUrl());
    }

    public String getNumbersUrl() {
        return this.numbersUrl;
    }

    public ServerConfiguration getSmsServer() {
        return new ServerConfiguration(String.format(this.getSmsUrl(), this.getSmsRegion()));
    }

    public SMSRegion getSmsRegion() {
        return this.smsRegion;
    }

    public String getSmsUrl() {
        return this.smsUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Configuration configuration) {
        return new Builder(configuration);
    }

    public static class Builder {
        private String keyId;
        private String keySecret;
        private String projectId;
        private String oauthUrl;
        private String numbersUrl;
        private SMSRegion smsRegion;
        private String smsUrl;

        protected Builder() {
        }

        protected Builder(Configuration configuration) {
            this.keyId = configuration.getKeyId();
            this.keySecret = configuration.getKeySecret();
            this.projectId = configuration.getProjectId();
            this.oauthUrl = configuration.getOAuthUrl();
            this.numbersUrl = configuration.getNumbersUrl();
            this.smsRegion = configuration.getSmsRegion();
            this.smsUrl = configuration.getSmsUrl();
        }

        public Configuration build() {
            return new Configuration(this.keyId, this.keySecret, this.projectId, this.oauthUrl, this.numbersUrl, this.smsRegion, this.smsUrl);
        }

        public Builder setKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder setKeySecret(String keySecret) {
            this.keySecret = keySecret;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setOAuthUrl(String oauthUrl) {
            this.oauthUrl = oauthUrl;
            return this;
        }

        public Builder setNumbersUrl(String numbersUrl) {
            this.numbersUrl = numbersUrl;
            return this;
        }

        public Builder setSmsRegion(SMSRegion smsRegion) {
            this.smsRegion = smsRegion;
            return this;
        }

        public Builder setSmsUrl(String smsUrl) {
            this.smsUrl = smsUrl;
            return this;
        }
    }
}

