/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.pdf417;

import java.awt.Dimension;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultTwoDimCanvasLogicHandler;
import org.krysalis.barcode4j.impl.pdf417.PDF417HighLevelEncoder;
import org.krysalis.barcode4j.impl.pdf417.PDF417LogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.ECIUtil;
import org.krysalis.barcode4j.tools.UnitConv;

public class PDF417Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);
    protected static final int DEFAULT_X_TO_Y_FACTOR = 3;
    protected static final int DEFAULT_COLUMN_COUNT = 2;
    protected static final int DEFAULT_ERROR_CORRECTION_LEVEL = 0;
    private static final double DEFAULT_WIDTH_TO_HEIGHT_RATIO = 3.0;
    private static final int MAX_ROW_COUNT = 90;
    private static final int MIN_ROW_COUNT = 3;
    private static final int MIN_COLUMN_COUNT = 1;
    private static final int MAX_COLUMN_COUNT = 30;
    private int minRows = 3;
    private int maxRows = 90;
    private int minCols = 1;
    private int maxCols = 30;
    private double widthToHeightRatio = 3.0;
    private int errorCorrectionLevel = 0;
    private String encoding = "Cp437";
    private boolean enableECI = false;

    public PDF417Bean() {
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.height = 3.0 * this.moduleWidth;
        this.setQuietZone(2.0 * this.moduleWidth);
        this.setColumns(2);
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler handler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvas));
        PDF417LogicImpl.generateBarcodeLogic(handler, msg, this);
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        int sourceCodeWords = PDF417HighLevelEncoder.encodeHighLevel(msg, this.getEncoding(), this.isECIEnabled()).length();
        Dimension dimension = PDF417LogicImpl.determineDimensions(this, sourceCodeWords);
        if (dimension == null) {
            throw new IllegalArgumentException("Unable to fit message in columns");
        }
        double width = (double)(17 * dimension.width + 69) * this.getModuleWidth();
        double height = this.getBarHeight() * (double)dimension.height;
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, height, width + 2.0 * qzh, height + 2.0 * qzv, qzh, qzv);
    }

    @Override
    public double getBarWidth(int width) {
        return (double)width * this.moduleWidth;
    }

    public int getColumns() {
        return this.minCols;
    }

    public int getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public int getMaxCols() {
        return this.maxCols;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getMinCols() {
        return this.minCols;
    }

    public int getMinRows() {
        return this.minRows;
    }

    public double getRowHeight() {
        return this.getBarHeight();
    }

    public double getWidthToHeightRatio() {
        return this.widthToHeightRatio;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isECIEnabled() {
        return this.enableECI;
    }

    private void checkValidColumnCount(int cols) {
        if (cols < 1 || cols > 30) {
            throw new IllegalArgumentException("The number of columns must be between 1 and 30");
        }
    }

    private void checkValidRowCount(int rows) {
        if (rows < 3 || rows > 90) {
            throw new IllegalArgumentException("The number of rows must be between 3 and 90");
        }
    }

    public void setColumns(int cols) {
        this.setMinCols(cols);
        this.setMaxCols(cols);
    }

    public void setErrorCorrectionLevel(int level) {
        if (level < 0 || level > 8) {
            throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
        }
        this.errorCorrectionLevel = level;
    }

    public void setMaxCols(int maxCols) {
        this.checkValidColumnCount(maxCols);
        this.maxCols = maxCols;
    }

    public void setMaxRows(int maxRows) {
        this.checkValidRowCount(maxRows);
        this.maxRows = maxRows;
    }

    public void setMinCols(int minCols) {
        this.checkValidColumnCount(minCols);
        this.minCols = minCols;
    }

    public void setMinRows(int minRows) {
        this.checkValidRowCount(minRows);
        this.minRows = minRows;
    }

    public void setRowHeight(double height) {
        this.setBarHeight(height);
    }

    public void setWidthToHeightRatio(double widthToHeightRatio) {
        this.widthToHeightRatio = widthToHeightRatio;
    }

    public void setEncoding(String encoding) {
        if (ECIUtil.getECIForEncoding(encoding) < 0) {
            throw new IllegalArgumentException("Not a valid encoding: " + encoding);
        }
        this.encoding = encoding;
    }

    public void setECIEnabled(boolean value) {
        this.enableECI = value;
    }
}

