/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.postnet;

import org.krysalis.barcode4j.BaselineAlignment;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractVariableHeightLogicHandler;
import org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import org.krysalis.barcode4j.impl.postnet.POSTNETBean;
import org.krysalis.barcode4j.output.Canvas;

public class POSTNETLogicHandler
extends AbstractVariableHeightLogicHandler {
    public POSTNETLogicHandler(HeightVariableBarcodeBean bcBean, Canvas canvas) {
        super(bcBean, canvas);
    }

    private double getStartY() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getVerticalQuietZone();
        }
        return 0.0;
    }

    @Override
    public void startBarcode(String msg, String formattedMsg) {
        super.startBarcode(msg, formattedMsg);
        this.y = this.getStartY();
    }

    @Override
    public void addBar(boolean black, int height) {
        POSTNETBean pnBean = (POSTNETBean)this.bcBean;
        double w = black ? this.bcBean.getBarWidth(1) : this.bcBean.getBarWidth(-1);
        double h = this.bcBean.getBarHeight(height);
        BaselineAlignment baselinePosition = pnBean.getBaselinePosition();
        if (black) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                if (baselinePosition == BaselineAlignment.ALIGN_TOP) {
                    this.canvas.drawRectWH(this.x, this.y + this.bcBean.getHumanReadableHeight(), w, h);
                } else if (baselinePosition == BaselineAlignment.ALIGN_BOTTOM) {
                    this.canvas.drawRectWH(this.x, this.y + this.bcBean.getHeight() - h, w, h);
                }
            } else if (baselinePosition == BaselineAlignment.ALIGN_TOP) {
                this.canvas.drawRectWH(this.x, this.y, w, h);
            } else if (baselinePosition == BaselineAlignment.ALIGN_BOTTOM) {
                this.canvas.drawRectWH(this.x, this.y + this.bcBean.getBarHeight() - h, w, h);
            }
        }
        this.x += w;
    }
}

