/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.qr;

import org.krysalis.barcode4j.impl.qr.QRConstants;

public class QRHighLevelEncoder
implements QRConstants {
    private final String msg;
    private final int encodingMode;

    public QRHighLevelEncoder(String msg) {
        this.msg = msg;
        this.encodingMode = this.analyzeMessage(msg);
    }

    public int getEncodingMode() {
        return this.encodingMode;
    }

    private int analyzeMessage(String msg) {
        int mode = 0;
        for (char ch : msg.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            if (mode == 0 && this.isSupportedAlphanumeric(ch)) {
                mode = 1;
                continue;
            }
            if (this.isSupportedAlphanumeric(ch)) continue;
            mode = 2;
            break;
        }
        return mode;
    }

    private boolean isSupportedAlphanumeric(char ch) {
        return ch < ALPHANUMERIC_TABLE.length && ALPHANUMERIC_TABLE[ch] >= 0;
    }
}

